/*
 * Decompiled with CFR 0.152.
 */
package processing.app.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import processing.app.Base;
import processing.app.Language;
import processing.app.Library;
import processing.app.Mode;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.SketchReference;
import processing.app.contrib.Contribution;
import processing.app.contrib.ContributionManager;
import processing.app.contrib.ContributionType;
import processing.app.contrib.ExamplesContribution;
import processing.app.ui.Toolkit;
import processing.app.ui.ZoomTreeCellRenderer;
import processing.core.PApplet;
import processing.data.StringDict;

public class ExamplesFrame
extends JFrame {
    protected Base base;
    protected Mode mode;
    protected File examplesContribFolder;

    public ExamplesFrame(final Base base, Mode mode) {
        super(Language.interpolate("examples.title", mode.getTitle()));
        this.base = base;
        this.mode = mode;
        this.examplesContribFolder = Base.getSketchbookExamplesFolder();
        Toolkit.setIcon(this);
        Toolkit.registerWindowCloseKeys(this.getRootPane(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExamplesFrame.this.setVisible(false);
            }
        });
        JPanel examplesPanel = new JPanel();
        examplesPanel.setLayout(new BorderLayout());
        examplesPanel.setBackground(Color.WHITE);
        JPanel openExamplesManagerPanel = new JPanel(new FlowLayout(1));
        JButton addExamplesButton = new JButton(Language.text("examples.add_examples"));
        openExamplesManagerPanel.add(addExamplesButton);
        openExamplesManagerPanel.setOpaque(false);
        MatteBorder lineBorder = BorderFactory.createMatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY);
        Border paddingBorder = BorderFactory.createEmptyBorder(3, 5, 1, 4);
        openExamplesManagerPanel.setBorder(BorderFactory.createCompoundBorder(lineBorder, paddingBorder));
        openExamplesManagerPanel.setAlignmentX(0.0f);
        openExamplesManagerPanel.setCursor(new Cursor(12));
        addExamplesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContributionManager.openExamples();
            }
        });
        final JTree tree = new JTree(this.buildTree());
        tree.setOpaque(true);
        tree.setAlignmentX(0.0f);
        tree.getSelectionModel().setSelectionMode(1);
        tree.setShowsRootHandles(true);
        tree.expandRow(0);
        tree.setRootVisible(false);
        tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
                    int selRow = tree.getRowForLocation(e.getX(), e.getY());
                    if (node != null && node.isLeaf() && selRow != -1) {
                        SketchReference sketch = (SketchReference)node.getUserObject();
                        base.handleOpen(sketch.getPath());
                    }
                }
            }
        });
        tree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    ExamplesFrame.this.setVisible(false);
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                DefaultMutableTreeNode node;
                if (e.getKeyChar() == '\n' && (node = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent()) != null && node.isLeaf()) {
                    SketchReference sketch = (SketchReference)node.getUserObject();
                    base.handleOpen(sketch.getPath());
                }
            }
        });
        tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                ExamplesFrame.this.updateExpanded(tree);
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                ExamplesFrame.this.updateExpanded(tree);
            }
        });
        tree.setBorder(new EmptyBorder(0, 5, 5, 5));
        if (Platform.isMacOS()) {
            tree.setToggleClickCount(2);
        } else {
            tree.setToggleClickCount(1);
        }
        tree.setCellRenderer(new ZoomTreeCellRenderer(mode));
        JScrollPane treePane = new JScrollPane(tree);
        treePane.setPreferredSize(Toolkit.zoom(250, 300));
        treePane.setBorder(new EmptyBorder(Toolkit.zoom(2), 0, 0, 0));
        treePane.setOpaque(true);
        treePane.setBackground(Color.WHITE);
        treePane.setAlignmentX(0.0f);
        examplesPanel.add((Component)openExamplesManagerPanel, "First");
        examplesPanel.add((Component)treePane, "Center");
        this.getContentPane().add(examplesPanel);
        this.pack();
        this.restoreExpanded(tree);
    }

    /*
     * Unable to fully structure code
     */
    public void setVisible() {
        roughWidth = this.getWidth() + 20;
        p = null;
        editor = this.base.getActiveEditor();
        if (editor == null) ** GOTO lbl-1000
        p = editor.getLocation();
        if (p.x < roughWidth) lbl-1000:
        // 2 sources

        {
            this.setLocationRelativeTo(null);
        } else {
            this.setLocation(p.x - roughWidth, p.y);
        }
        this.setVisible(true);
    }

    protected void updateExpanded(JTree tree) {
        Enumeration<TreePath> en = tree.getExpandedDescendants(new TreePath(tree.getModel().getRoot()));
        StringBuilder s = new StringBuilder();
        while (en.hasMoreElements()) {
            Object[] path;
            TreePath tp = en.nextElement();
            Object[] objectArray = path = tp.getPath();
            int n = path.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                DefaultMutableTreeNode p = (DefaultMutableTreeNode)o;
                String name = (String)p.getUserObject();
                s.append(name);
                s.append(File.separatorChar);
                ++n2;
            }
            s.setCharAt(s.length() - 1, File.pathSeparatorChar);
        }
        s.setLength(s.length() - 1);
        String pref = "examples." + this.getClass().getName() + ".visible";
        Preferences.set(pref, s.toString());
        Preferences.save();
    }

    protected void restoreExpanded(JTree tree) {
        String pref = "examples." + this.getClass().getName() + ".visible";
        String value = Preferences.get(pref);
        if (value != null) {
            String[] paths;
            String[] stringArray = paths = PApplet.split((String)value, (String)File.pathSeparator);
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                String[] items = PApplet.split((String)path, (String)File.separator);
                DefaultMutableTreeNode[] nodes = new DefaultMutableTreeNode[items.length];
                this.expandTree(tree, null, items, nodes, 0);
                ++n2;
            }
        }
    }

    void expandTree(JTree tree, Object object, String[] items, DefaultMutableTreeNode[] nodes, int index) {
        TreeModel model = tree.getModel();
        if (index == 0) {
            nodes[0] = (DefaultMutableTreeNode)model.getRoot();
            this.expandTree(tree, nodes[0], items, nodes, 1);
        } else if (index < items.length) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)object;
            int count = model.getChildCount(node);
            int i = 0;
            while (i < count) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)model.getChild(node, i);
                if (items[index].equals(child.getUserObject())) {
                    nodes[index] = child;
                    this.expandTree(tree, child, items, nodes, index + 1);
                }
                ++i;
            }
        } else {
            tree.expandPath(new TreePath(nodes));
        }
    }

    protected DefaultMutableTreeNode buildTree() {
        DefaultMutableTreeNode contributedExamplesNode;
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        try {
            File[] examples = this.mode.getExampleCategoryFolders();
            File[] fileArray = examples;
            int n = examples.length;
            int n2 = 0;
            while (n2 < n) {
                File subFolder = fileArray[n2];
                DefaultMutableTreeNode subNode = new DefaultMutableTreeNode(subFolder.getName());
                if (this.base.addSketches(subNode, subFolder, true)) {
                    root.add(subNode);
                }
                ++n2;
            }
            DefaultMutableTreeNode foundationLibraries = new DefaultMutableTreeNode(Language.text("examples.core_libraries"));
            for (Library lib : this.mode.coreLibraries) {
                DefaultMutableTreeNode libNode;
                if (!lib.hasExamples() || !this.base.addSketches(libNode = new DefaultMutableTreeNode(lib.getName()), lib.getExamplesFolder(), true)) continue;
                foundationLibraries.add(libNode);
            }
            if (foundationLibraries.getChildCount() > 0) {
                root.add(foundationLibraries);
            }
            DefaultMutableTreeNode contributedLibExamples = new DefaultMutableTreeNode(Language.text("examples.libraries"));
            for (Library lib : this.mode.contribLibraries) {
                if (!lib.hasExamples()) continue;
                DefaultMutableTreeNode libNode = new DefaultMutableTreeNode(lib.getName());
                this.base.addSketches(libNode, lib.getExamplesFolder(), true);
                contributedLibExamples.add(libNode);
            }
            if (contributedLibExamples.getChildCount() > 0) {
                root.add(contributedLibExamples);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if ((contributedExamplesNode = this.buildContribTree()).getChildCount() > 0) {
            root.add(contributedExamplesNode);
        }
        return root;
    }

    protected DefaultMutableTreeNode buildContribTree() {
        DefaultMutableTreeNode contribExamplesNode = new DefaultMutableTreeNode(Language.text("examples.contributed"));
        try {
            File[] subfolders = ContributionType.EXAMPLES.listCandidates(this.examplesContribFolder);
            if (subfolders != null) {
                File[] fileArray = subfolders;
                int n = subfolders.length;
                int n2 = 0;
                while (n2 < n) {
                    DefaultMutableTreeNode subNode;
                    File sub = fileArray[n2];
                    StringDict props = Contribution.loadProperties(sub, ContributionType.EXAMPLES);
                    if (props != null && ExamplesContribution.isCompatible(this.base, props) && this.base.addSketches(subNode = new DefaultMutableTreeNode(props.get("name")), sub, true)) {
                        contribExamplesNode.add(subNode);
                        int exampleNodeNumber = -1;
                        int i = 0;
                        while (i < subNode.getChildCount()) {
                            if (subNode.getChildAt(i).toString().equals("examples")) {
                                exampleNodeNumber = i;
                            }
                            ++i;
                        }
                        if (exampleNodeNumber != -1) {
                            TreeNode exampleNode = subNode.getChildAt(exampleNodeNumber);
                            subNode.remove(exampleNodeNumber);
                            int count = exampleNode.getChildCount();
                            int j = 0;
                            while (j < count) {
                                subNode.add((DefaultMutableTreeNode)exampleNode.getChildAt(0));
                                ++j;
                            }
                        }
                    }
                    ++n2;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return contribExamplesNode;
    }
}

