/*
 * Decompiled with CFR 0.152.
 */
package processing.app.syntax;

import java.awt.event.KeyEvent;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.syntax.DefaultInputHandler;
import processing.app.syntax.InputHandler;
import processing.app.ui.Editor;

public class PdeInputHandler
extends DefaultInputHandler {
    protected Editor editor;

    public PdeInputHandler(Editor editor) {
        this();
        this.editor = editor;
    }

    public PdeInputHandler() {
        String mod = Platform.isMacOS() ? "A" : "C";
        this.addKeyBinding("BACK_SPACE", InputHandler.BACKSPACE);
        if (Preferences.getBoolean("editor.keys.shift_backspace_is_delete")) {
            this.addKeyBinding("S+BACK_SPACE", InputHandler.DELETE);
        } else {
            this.addKeyBinding("S+BACK_SPACE", InputHandler.BACKSPACE);
        }
        this.addKeyBinding("DELETE", InputHandler.DELETE);
        this.addKeyBinding("S+DELETE", InputHandler.DELETE);
        this.addKeyBinding(String.valueOf(mod) + "+BACK_SPACE", InputHandler.BACKSPACE_WORD);
        this.addKeyBinding(String.valueOf(mod) + "S+BACK_SPACE", InputHandler.BACKSPACE_WORD);
        this.addKeyBinding(String.valueOf(mod) + "+DELETE", InputHandler.DELETE_WORD);
        this.addKeyBinding(String.valueOf(mod) + "S+DELETE", InputHandler.DELETE_WORD);
        this.addKeyBinding("INSERT", InputHandler.OVERWRITE);
        if (Preferences.getBoolean("editor.keys.alternative_cut_copy_paste")) {
            this.addKeyBinding("C+INSERT", InputHandler.CLIPBOARD_COPY);
            this.addKeyBinding("S+INSERT", InputHandler.CLIPBOARD_PASTE);
            this.addKeyBinding("S+DELETE", InputHandler.CLIPBOARD_CUT);
        }
        if (Preferences.getBoolean("editor.keys.home_and_end_travel_far")) {
            this.addKeyBinding("HOME", InputHandler.DOCUMENT_HOME);
            this.addKeyBinding("END", InputHandler.DOCUMENT_END);
            this.addKeyBinding("S+HOME", InputHandler.SELECT_DOC_HOME);
            this.addKeyBinding("S+END", InputHandler.SELECT_DOC_END);
        } else {
            this.addKeyBinding("HOME", InputHandler.HOME);
            this.addKeyBinding("END", InputHandler.END);
            this.addKeyBinding("S+HOME", InputHandler.SELECT_HOME);
            this.addKeyBinding("S+END", InputHandler.SELECT_END);
            this.addKeyBinding("C+HOME", InputHandler.DOCUMENT_HOME);
            this.addKeyBinding("C+END", InputHandler.DOCUMENT_END);
            this.addKeyBinding("CS+HOME", InputHandler.SELECT_DOC_HOME);
            this.addKeyBinding("CS+END", InputHandler.SELECT_DOC_END);
        }
        if (Platform.isMacOS()) {
            this.addKeyBinding("C+A", InputHandler.HOME);
            this.addKeyBinding("CS+A", InputHandler.SELECT_HOME);
            this.addKeyBinding("C+E", InputHandler.END);
            this.addKeyBinding("CS+E", InputHandler.SELECT_END);
            this.addKeyBinding("C+D", InputHandler.DELETE);
            this.addKeyBinding("C+B", InputHandler.PREV_CHAR);
            this.addKeyBinding("CS+B", InputHandler.SELECT_PREV_CHAR);
            this.addKeyBinding("C+F", InputHandler.NEXT_CHAR);
            this.addKeyBinding("CS+F", InputHandler.SELECT_NEXT_CHAR);
            this.addKeyBinding("C+H", InputHandler.BACKSPACE);
            this.addKeyBinding("C+N", InputHandler.NEXT_LINE);
            this.addKeyBinding("CS+N", InputHandler.SELECT_NEXT_LINE);
            this.addKeyBinding("C+P", InputHandler.PREV_LINE);
            this.addKeyBinding("CS+P", InputHandler.SELECT_PREV_LINE);
        }
        if (Platform.isMacOS()) {
            this.addKeyBinding("M+LEFT", InputHandler.HOME);
            this.addKeyBinding("M+RIGHT", InputHandler.END);
            this.addKeyBinding("MS+LEFT", InputHandler.SELECT_HOME);
            this.addKeyBinding("MS+RIGHT", InputHandler.SELECT_END);
        } else {
            this.addKeyBinding("C+LEFT", InputHandler.HOME);
            this.addKeyBinding("C+RIGHT", InputHandler.END);
            this.addKeyBinding("CS+HOME", InputHandler.SELECT_HOME);
            this.addKeyBinding("CS+END", InputHandler.SELECT_END);
        }
        this.addKeyBinding("PAGE_UP", InputHandler.PREV_PAGE);
        this.addKeyBinding("PAGE_DOWN", InputHandler.NEXT_PAGE);
        this.addKeyBinding("S+PAGE_UP", InputHandler.SELECT_PREV_PAGE);
        this.addKeyBinding("S+PAGE_DOWN", InputHandler.SELECT_NEXT_PAGE);
        this.addKeyBinding("LEFT", InputHandler.PREV_CHAR);
        this.addKeyBinding("S+LEFT", InputHandler.SELECT_PREV_CHAR);
        this.addKeyBinding(String.valueOf(mod) + "+LEFT", InputHandler.PREV_WORD);
        this.addKeyBinding(String.valueOf(mod) + "S+LEFT", InputHandler.SELECT_PREV_WORD);
        this.addKeyBinding("RIGHT", InputHandler.NEXT_CHAR);
        this.addKeyBinding("S+RIGHT", InputHandler.SELECT_NEXT_CHAR);
        this.addKeyBinding(String.valueOf(mod) + "+RIGHT", InputHandler.NEXT_WORD);
        this.addKeyBinding(String.valueOf(mod) + "S+RIGHT", InputHandler.SELECT_NEXT_WORD);
        this.addKeyBinding("UP", InputHandler.PREV_LINE);
        this.addKeyBinding(String.valueOf(mod) + "+UP", InputHandler.PREV_LINE);
        this.addKeyBinding("S+UP", InputHandler.SELECT_PREV_LINE);
        this.addKeyBinding("DOWN", InputHandler.NEXT_LINE);
        this.addKeyBinding(String.valueOf(mod) + "+DOWN", InputHandler.NEXT_LINE);
        this.addKeyBinding("S+DOWN", InputHandler.SELECT_NEXT_LINE);
        this.addKeyBinding("MS+UP", InputHandler.SELECT_DOC_HOME);
        this.addKeyBinding("CS+UP", InputHandler.SELECT_DOC_HOME);
        this.addKeyBinding("MS+DOWN", InputHandler.SELECT_DOC_END);
        this.addKeyBinding("CS+DOWN", InputHandler.SELECT_DOC_END);
        this.addKeyBinding(String.valueOf(mod) + "+ENTER", InputHandler.REPEAT);
    }

    protected boolean isMnemonic(KeyEvent event) {
        return !Platform.isMacOS() && (event.getModifiers() & 8) != 0 && (event.getModifiers() & 2) == 0 && event.getKeyChar() != '\u0000';
    }

    @Override
    public void keyPressed(KeyEvent event) {
        if ((event.getModifiers() & 2) != 0 && event.getKeyChar() == ',') {
            return;
        }
        if (this.isMnemonic(event)) {
            return;
        }
        if (!this.handlePressed(event)) {
            super.keyPressed(event);
        }
    }

    @Override
    public void keyTyped(KeyEvent event) {
        if (this.isMnemonic(event)) {
            return;
        }
        if (!this.handleTyped(event)) {
            super.keyTyped(event);
        }
    }

    public boolean handlePressed(KeyEvent event) {
        return false;
    }

    public boolean handleTyped(KeyEvent event) {
        return false;
    }

    @Override
    public void handleInputMethodCommit() {
        this.editor.getSketch().setModified(true);
    }
}

