/*
 * Decompiled with CFR 0.152.
 */
package processing.app.syntax;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public class HtmlSelection
implements Transferable {
    private static List<DataFlavor> flavors;
    private String html;

    static {
        try {
            flavors = new ArrayList<DataFlavor>();
            flavors.add(DataFlavor.stringFlavor);
            flavors.add(new DataFlavor("text/html;class=java.lang.String"));
            flavors.add(new DataFlavor("text/html;class=java.io.Reader"));
            flavors.add(new DataFlavor("text/html;charset=unicode;class=java.io.InputStream"));
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
    }

    public HtmlSelection(String html) {
        this.html = html;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return flavors.toArray(new DataFlavor[flavors.size()]);
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavors.contains(flavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (flavor.equals(DataFlavor.stringFlavor)) {
            return this.html;
        }
        if (String.class.equals(flavor.getRepresentationClass())) {
            return this.html;
        }
        if (Reader.class.equals(flavor.getRepresentationClass())) {
            return new StringReader(this.html);
        }
        if (InputStream.class.equals(flavor.getRepresentationClass())) {
            return new StringReader(this.html);
        }
        throw new UnsupportedFlavorException(flavor);
    }
}

