/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.media.quicktime;

import ch.randelshofer.io.ImageOutputStreamAdapter;
import ch.randelshofer.media.quicktime.AppleRLEEncoder;
import ch.randelshofer.media.quicktime.DataAtomOutputStream;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.zip.DeflaterOutputStream;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import javax.sound.sampled.AudioFormat;

public class QuickTimeWriter {
    private ImageOutputStream out;
    private long streamOffset;
    private Date creationTime;
    private long movieTimeScale = 600L;
    private ArrayList<Track> tracks = new ArrayList();
    private States state = States.REALIZED;
    private WideDataAtom mdatAtom;
    private long mdatOffset;
    private CompositeAtom moovAtom;

    public QuickTimeWriter(File file) throws IOException {
        if (file.exists()) {
            file.delete();
        }
        this.out = new FileImageOutputStream(file);
        this.streamOffset = 0L;
    }

    public QuickTimeWriter(ImageOutputStream imageOutputStream) throws IOException {
        this.out = imageOutputStream;
        this.streamOffset = imageOutputStream.getStreamPosition();
    }

    public void setMovieTimeScale(long l) {
        if (l < 1L || l > 0x200000000L) {
            throw new IllegalArgumentException("timeScale must be between 1 and 2^32:" + l);
        }
        this.movieTimeScale = l;
    }

    public long getMovieTimeScale() {
        return this.movieTimeScale;
    }

    public long getMediaTimeScale(int n) {
        return this.tracks.get((int)n).mediaTimeScale;
    }

    public long getMediaDuration(int n) {
        return this.tracks.get((int)n).mediaDuration;
    }

    public long getUneditedTrackDuration(int n) {
        Track track = this.tracks.get(n);
        return track.mediaDuration * track.mediaTimeScale / this.movieTimeScale;
    }

    public long getTrackDuration(int n) {
        return this.tracks.get(n).getTrackDuration(this.movieTimeScale);
    }

    public long getMovieDuration() {
        long l = 0L;
        for (Track track : this.tracks) {
            l = Math.max(l, track.getTrackDuration(this.movieTimeScale));
        }
        return l;
    }

    public void setVideoColorTable(int n, IndexColorModel indexColorModel) {
        VideoTrack videoTrack = (VideoTrack)this.tracks.get(n);
        videoTrack.videoColorTable = indexColorModel;
    }

    public IndexColorModel getVideoColorTable(int n) {
        VideoTrack videoTrack = (VideoTrack)this.tracks.get(n);
        return videoTrack.videoColorTable;
    }

    public void setEditList(int n, Edit[] editArray) {
        if (editArray != null && editArray.length > 0 && editArray[editArray.length - 1].mediaTime == -1) {
            throw new IllegalArgumentException("Edit list must not end with empty edit.");
        }
        this.tracks.get((int)n).editList = editArray;
    }

    public void addVideoTrack(VideoFormat videoFormat, long l, int n, int n2) throws IOException {
        this.addVideoTrack(videoFormat.compressionType, videoFormat.compressorName, l, n, n2, 24, videoFormat.allSamplesAreSyncSamples ? 1 : 30);
    }

    public void addVideoTrack(String string, String string2, long l, int n, int n2, int n3, int n4) throws IOException {
        this.ensureStarted();
        if (string == null || string.length() != 4) {
            throw new IllegalArgumentException("compressionType must be 4 characters long:" + string);
        }
        if (string2 == null || string2.length() < 1 || string2.length() > 32) {
            throw new IllegalArgumentException("compressorName must be between 1 and 32 characters long:" + string);
        }
        if (l < 1L || l > 0x200000000L) {
            throw new IllegalArgumentException("timeScale must be between 1 and 2^32:" + l);
        }
        if (n < 1 || n2 < 1) {
            throw new IllegalArgumentException("Width and height must be greater than 0, width:" + n + " height:" + n2);
        }
        VideoTrack videoTrack = new VideoTrack();
        videoTrack.mediaCompressionType = string;
        videoTrack.mediaCompressorName = string2;
        videoTrack.mediaTimeScale = l;
        videoTrack.videoWidth = n;
        videoTrack.videoHeight = n2;
        videoTrack.videoDepth = n3;
        videoTrack.syncInterval = n4;
        VideoFormat[] videoFormatArray = VideoFormat.values();
        int n5 = videoFormatArray.length;
        int n6 = 0;
        while (n6 < n5) {
            VideoFormat videoFormat = videoFormatArray[n6];
            if (videoFormat.compressionType.equals(string)) {
                videoTrack.videoEncoding = videoFormat;
                break;
            }
            ++n6;
        }
        this.tracks.add(videoTrack);
    }

    public void addAudioTrack(AudioFormat audioFormat) throws IOException {
        String string;
        boolean bl;
        int n;
        int n2;
        int n3;
        int n4;
        long l;
        double d;
        block16: {
            block17: {
                boolean bl2;
                block15: {
                    this.ensureStarted();
                    d = audioFormat.getSampleRate();
                    l = (int)Math.floor(d);
                    n4 = audioFormat.getSampleSizeInBits();
                    n3 = audioFormat.getChannels();
                    bl2 = audioFormat.isBigEndian();
                    n2 = (int)(audioFormat.getSampleRate() / audioFormat.getFrameRate());
                    n = audioFormat.getFrameSize();
                    boolean bl3 = bl = audioFormat.getProperty("vbr") != null && (Boolean)audioFormat.getProperty("vbr") != false;
                    if (!audioFormat.getEncoding().equals(AudioFormat.Encoding.ALAW)) break block15;
                    string = "alaw";
                    if (n4 != 8) {
                        throw new IllegalArgumentException("Sample size of 8 for ALAW required:" + n4);
                    }
                    break block16;
                }
                if (!audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) break block17;
                switch (n4) {
                    case 16: {
                        string = bl2 ? "twos" : "sowt";
                        break block16;
                    }
                    case 24: {
                        string = "in24";
                        break block16;
                    }
                    case 32: {
                        string = "in32";
                        break block16;
                    }
                    default: {
                        throw new IllegalArgumentException("Sample size of 16, 24 or 32 for PCM_SIGNED required:" + n4);
                    }
                }
            }
            if (audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED)) {
                if (n4 != 8) {
                    throw new IllegalArgumentException("Sample size of 8 PCM_UNSIGNED required:" + n4);
                }
                string = "raw ";
            } else if (audioFormat.getEncoding().equals(AudioFormat.Encoding.ULAW)) {
                if (n4 != 8) {
                    throw new IllegalArgumentException("Sample size of 8 for ULAW required:" + n4);
                }
                string = "ulaw";
            } else if (audioFormat.getEncoding().toString().equals("MP3")) {
                string = ".mp3";
            } else {
                string = audioFormat.getEncoding().toString();
                if (string.length() != 4) {
                    throw new IllegalArgumentException("Unsupported encoding:" + audioFormat.getEncoding());
                }
            }
        }
        this.addAudioTrack(string, l, d, n3, n4, bl, n2, n);
    }

    public void addAudioTrack(String string, long l, double d, int n, int n2, boolean bl, int n3, int n4) throws IOException {
        this.ensureStarted();
        if (string == null || string.length() != 4) {
            throw new IllegalArgumentException("audioFormat must be 4 characters long:" + string);
        }
        if (l < 1L || l > 0x200000000L) {
            throw new IllegalArgumentException("timeScale must be between 1 and 2^32:" + l);
        }
        if (l != (long)((int)Math.floor(d))) {
            throw new IllegalArgumentException("timeScale: " + l + " must match integer portion of sampleRate: " + d);
        }
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException("numberOfChannels must be 1 or 2: " + n);
        }
        if (n2 != 8 && n2 != 16) {
            throw new IllegalArgumentException("sampleSize must be 8 or 16: " + n);
        }
        AudioTrack audioTrack = new AudioTrack();
        audioTrack.mediaCompressionType = string;
        audioTrack.mediaTimeScale = l;
        audioTrack.soundSampleRate = d;
        audioTrack.soundCompressionId = bl ? -2 : -1;
        audioTrack.soundNumberOfChannels = n;
        audioTrack.soundSampleSize = n2;
        audioTrack.soundSamplesPerPacket = n3;
        if (bl) {
            audioTrack.soundBytesPerPacket = n4;
            audioTrack.soundBytesPerFrame = n4 * n;
        } else {
            audioTrack.soundBytesPerPacket = n4 / n;
            audioTrack.soundBytesPerFrame = n4;
        }
        audioTrack.soundBytesPerSample = n2 / 8;
        this.tracks.add(audioTrack);
    }

    public void setCompressionQuality(int n, float f) {
        ((VideoTrack)this.tracks.get(n)).videoQuality = f;
    }

    public float getCompressionQuality(int n) {
        return ((VideoTrack)this.tracks.get(n)).videoQuality;
    }

    public void setSyncInterval(int n, int n2) {
        ((VideoTrack)this.tracks.get(n)).syncInterval = n2;
    }

    public int getSyncInterval(int n) {
        return ((VideoTrack)this.tracks.get(n)).syncInterval;
    }

    private void ensureStarted() throws IOException {
        this.ensureOpen();
        if (this.state == States.FINISHED) {
            throw new IOException("Can not write into finished movie.");
        }
        if (this.state != States.STARTED) {
            this.creationTime = new Date();
            this.writeProlog();
            this.mdatAtom = new WideDataAtom("mdat");
            this.state = States.STARTED;
        }
    }

    public void writeFrame(int n, BufferedImage bufferedImage, long l) throws IOException {
        boolean bl;
        if (l <= 0L) {
            throw new IllegalArgumentException("Duration must be greater 0.");
        }
        VideoTrack videoTrack = (VideoTrack)this.tracks.get(n);
        if (videoTrack.mediaType != MediaType.VIDEO) {
            throw new IllegalArgumentException("Track " + n + " is not a video track");
        }
        if (videoTrack.videoEncoding == null) {
            throw new UnsupportedOperationException("Encoding not supported.");
        }
        this.ensureStarted();
        if (videoTrack.videoWidth != bufferedImage.getWidth() || videoTrack.videoHeight != bufferedImage.getHeight()) {
            throw new IllegalArgumentException("Dimensions of frame[" + this.tracks.get(n).getSampleCount() + "] (width=" + bufferedImage.getWidth() + ", height=" + bufferedImage.getHeight() + ") differs from video dimension (width=" + videoTrack.videoWidth + ", height=" + videoTrack.videoHeight + ") in track " + n + ".");
        }
        long l2 = this.getRelativeStreamPosition();
        block0 : switch (videoTrack.videoEncoding) {
            case RAW: {
                Object object;
                bl = true;
                switch (videoTrack.videoDepth) {
                    case 8: {
                        if (bufferedImage.getType() != 13) {
                            throw new IllegalArgumentException("BufferedImage type " + bufferedImage.getType() + " does not match track type " + 13 + ".");
                        }
                        object = bufferedImage.getRaster();
                        int n2 = ((Raster)object).getSampleModel().getWidth();
                        Rectangle rectangle = ((Raster)object).getBounds();
                        rectangle.x -= ((Raster)object).getSampleModelTranslateX();
                        rectangle.y -= ((Raster)object).getSampleModelTranslateY();
                        DataBufferByte dataBufferByte = (DataBufferByte)((Raster)object).getDataBuffer();
                        byte[] byArray = dataBufferByte.getData();
                        int n3 = rectangle.x + rectangle.y * n2;
                        int n4 = rectangle.x + (rectangle.y + rectangle.height) * n2;
                        while (n3 < n4) {
                            this.mdatAtom.getOutputStream().write(byArray, n3, rectangle.width);
                            n3 += n2;
                        }
                        break block0;
                    }
                    case 24: {
                        object = bufferedImage.getRaster();
                        int[] nArray = new int[videoTrack.videoWidth * 3];
                        byte[] byArray = new byte[videoTrack.videoWidth * 3];
                        int n5 = 0;
                        while (n5 < videoTrack.videoHeight) {
                            nArray = ((Raster)object).getPixels(0, n5, videoTrack.videoWidth, 1, nArray);
                            int n6 = 0;
                            int n7 = videoTrack.videoWidth * 3;
                            while (n6 < n7) {
                                byArray[n6] = (byte)nArray[n6];
                                ++n6;
                            }
                            this.mdatAtom.getOutputStream().write(byArray);
                            ++n5;
                        }
                        break block0;
                    }
                    default: {
                        throw new UnsupportedOperationException("Encoding not supported.");
                    }
                }
            }
            case JPG: {
                bl = true;
                Object object = ImageIO.getImageWritersByMIMEType("image/jpeg").next();
                ImageWriteParam imageWriteParam = ((ImageWriter)object).getDefaultWriteParam();
                imageWriteParam.setCompressionMode(2);
                imageWriteParam.setCompressionQuality(videoTrack.videoQuality);
                MemoryCacheImageOutputStream memoryCacheImageOutputStream = new MemoryCacheImageOutputStream(this.mdatAtom.getOutputStream());
                ((ImageWriter)object).setOutput(memoryCacheImageOutputStream);
                IIOImage iIOImage = new IIOImage(bufferedImage, null, null);
                ((ImageWriter)object).write(null, iIOImage, imageWriteParam);
                ((ImageWriter)object).dispose();
                break;
            }
            case PNG: {
                bl = true;
                Object object = ImageIO.getImageWritersByMIMEType("image/png").next();
                ImageWriteParam imageWriteParam = ((ImageWriter)object).getDefaultWriteParam();
                MemoryCacheImageOutputStream memoryCacheImageOutputStream = new MemoryCacheImageOutputStream(this.mdatAtom.getOutputStream());
                ((ImageWriter)object).setOutput(memoryCacheImageOutputStream);
                IIOImage iIOImage = new IIOImage(bufferedImage, null, null);
                ((ImageWriter)object).write(null, iIOImage, imageWriteParam);
                ((ImageWriter)object).dispose();
                break;
            }
            case RLE: {
                bl = videoTrack.previousData == null || videoTrack.syncInterval != 0 && videoTrack.sampleCount % (long)videoTrack.syncInterval == 0L;
                Object object = bufferedImage.getRaster();
                int n8 = ((Raster)object).getSampleModel().getWidth();
                Rectangle rectangle = ((Raster)object).getBounds();
                rectangle.x -= ((Raster)object).getSampleModelTranslateX();
                rectangle.y -= ((Raster)object).getSampleModelTranslateY();
                if (videoTrack.encoder == null) {
                    videoTrack.encoder = new AppleRLEEncoder();
                }
                AppleRLEEncoder appleRLEEncoder = videoTrack.encoder;
                switch (videoTrack.videoDepth) {
                    case 16: {
                        DataBufferUShort dataBufferUShort = (DataBufferUShort)((Raster)object).getDataBuffer();
                        short[] sArray = dataBufferUShort.getData();
                        if (bl) {
                            appleRLEEncoder.writeKey16(this.mdatAtom.getOutputStream(), sArray, rectangle.width, rectangle.height, rectangle.x + rectangle.y * n8, n8);
                        } else {
                            appleRLEEncoder.writeDelta16(this.mdatAtom.getOutputStream(), sArray, (short[])videoTrack.previousData, rectangle.width, rectangle.height, rectangle.x + rectangle.y * n8, n8);
                        }
                        if (videoTrack.previousData == null) {
                            videoTrack.previousData = new short[sArray.length];
                        }
                        System.arraycopy(sArray, 0, videoTrack.previousData, 0, sArray.length);
                        break block0;
                    }
                    case 24: {
                        DataBufferInt dataBufferInt = (DataBufferInt)((Raster)object).getDataBuffer();
                        int[] nArray = dataBufferInt.getData();
                        if (bl) {
                            appleRLEEncoder.writeKey24(this.mdatAtom.getOutputStream(), nArray, rectangle.width, rectangle.height, rectangle.x + rectangle.y * n8, n8);
                        } else {
                            appleRLEEncoder.writeDelta24(this.mdatAtom.getOutputStream(), nArray, (int[])videoTrack.previousData, rectangle.width, rectangle.height, rectangle.x + rectangle.y * n8, n8);
                        }
                        if (videoTrack.previousData == null) {
                            videoTrack.previousData = new int[nArray.length];
                        }
                        System.arraycopy(nArray, 0, videoTrack.previousData, 0, nArray.length);
                        break block0;
                    }
                    case 32: {
                        DataBufferInt dataBufferInt = (DataBufferInt)((Raster)object).getDataBuffer();
                        int[] nArray = dataBufferInt.getData();
                        if (bl) {
                            appleRLEEncoder.writeKey32(this.mdatAtom.getOutputStream(), nArray, bufferedImage.getWidth(), bufferedImage.getHeight(), 0, bufferedImage.getWidth());
                        } else {
                            appleRLEEncoder.writeDelta32(this.mdatAtom.getOutputStream(), nArray, (int[])videoTrack.previousData, bufferedImage.getWidth(), bufferedImage.getHeight(), 0, bufferedImage.getWidth());
                        }
                        if (videoTrack.previousData == null) {
                            videoTrack.previousData = new int[nArray.length];
                        }
                        System.arraycopy(nArray, 0, videoTrack.previousData, 0, nArray.length);
                        break block0;
                    }
                }
                throw new UnsupportedOperationException("Encoding not supported.");
            }
            default: {
                throw new UnsupportedOperationException("Encoding not supported.");
            }
        }
        long l3 = this.getRelativeStreamPosition() - l2;
        videoTrack.addSample(new Sample(l, l2, l3), 1, bl);
    }

    public void writeSample(int n, File file, long l) throws IOException {
        this.writeSample(n, file, l, true);
    }

    public void writeSample(int n, File file, long l, boolean bl) throws IOException {
        this.ensureStarted();
        try (FileInputStream fileInputStream = null;){
            fileInputStream = new FileInputStream(file);
            this.writeSample(n, fileInputStream, l, bl);
        }
    }

    public void writeSample(int n, InputStream inputStream, long l) throws IOException {
        this.writeSample(n, inputStream, l, true);
    }

    public void writeSample(int n, InputStream inputStream, long l, boolean bl) throws IOException {
        int n2;
        this.ensureStarted();
        if (l <= 0L) {
            throw new IllegalArgumentException("duration must be greater 0");
        }
        Track track = this.tracks.get(n);
        this.ensureOpen();
        this.ensureStarted();
        long l2 = this.getRelativeStreamPosition();
        DataAtomOutputStream dataAtomOutputStream = this.mdatAtom.getOutputStream();
        byte[] byArray = new byte[4096];
        while ((n2 = inputStream.read(byArray)) != -1) {
            ((OutputStream)dataAtomOutputStream).write(byArray, 0, n2);
        }
        long l3 = this.getRelativeStreamPosition() - l2;
        track.addSample(new Sample(l, l2, l3), 1, bl);
    }

    public void writeSample(int n, byte[] byArray, long l) throws IOException {
        this.ensureStarted();
        this.writeSample(n, byArray, 0, byArray.length, l, true);
    }

    public void writeSample(int n, byte[] byArray, long l, boolean bl) throws IOException {
        this.ensureStarted();
        this.writeSample(n, byArray, 0, byArray.length, l, bl);
    }

    public void writeSample(int n, byte[] byArray, int n2, int n3, long l) throws IOException {
        this.ensureStarted();
        this.writeSample(n, byArray, n2, n3, l, true);
    }

    public void writeSample(int n, byte[] byArray, int n2, int n3, long l, boolean bl) throws IOException {
        this.ensureStarted();
        if (l <= 0L) {
            throw new IllegalArgumentException("duration must be greater 0");
        }
        Track track = this.tracks.get(n);
        this.ensureOpen();
        this.ensureStarted();
        long l2 = this.getRelativeStreamPosition();
        DataAtomOutputStream dataAtomOutputStream = this.mdatAtom.getOutputStream();
        ((OutputStream)dataAtomOutputStream).write(byArray, n2, n3);
        track.addSample(new Sample(l, l2, n3), 1, bl);
    }

    public void writeSamples(int n, int n2, byte[] byArray, int n3) throws IOException {
        this.writeSamples(n, n2, byArray, 0, byArray.length, n3, true);
    }

    public void writeSamples(int n, int n2, byte[] byArray, int n3, int n4, int n5) throws IOException {
        this.writeSamples(n, n2, byArray, n3, n4, n5, true);
    }

    public void writeSamples(int n, int n2, byte[] byArray, int n3, int n4, int n5, boolean bl) throws IOException {
        this.ensureStarted();
        if (n5 <= 0) {
            throw new IllegalArgumentException("sampleDuration must be greater 0, sampleDuration=" + n5);
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("sampleCount must be greater 0, sampleCount=" + n2);
        }
        if (n4 % n2 != 0) {
            throw new IllegalArgumentException("len must be divisable by sampleCount len=" + n4 + " sampleCount=" + n2);
        }
        Track track = this.tracks.get(n);
        this.ensureOpen();
        this.ensureStarted();
        long l = this.getRelativeStreamPosition();
        DataAtomOutputStream dataAtomOutputStream = this.mdatAtom.getOutputStream();
        ((OutputStream)dataAtomOutputStream).write(byArray, n3, n4);
        int n6 = n4 / n2;
        Sample sample = new Sample(n5, l, n6);
        Sample sample2 = new Sample(n5, l + (long)(n6 * (n2 - 1)), n6);
        track.addChunk(new Chunk(sample, sample2, n2, 1), bl);
    }

    public void close() throws IOException {
        try {
            if (this.state == States.STARTED) {
                this.finish();
            }
        }
        finally {
            if (this.state != States.CLOSED) {
                this.out.close();
                this.state = States.CLOSED;
            }
        }
    }

    public void finish() throws IOException {
        this.ensureOpen();
        if (this.state != States.FINISHED) {
            int n = 0;
            int n2 = this.tracks.size();
            while (n < n2) {
                ++n;
            }
            this.mdatAtom.finish();
            this.writeEpilog();
            this.state = States.FINISHED;
        }
    }

    private void ensureOpen() throws IOException {
        if (this.state == States.CLOSED) {
            throw new IOException("Stream closed");
        }
    }

    private long getRelativeStreamPosition() throws IOException {
        return this.out.getStreamPosition() - this.streamOffset;
    }

    private void seekRelative(long l) throws IOException {
        this.out.seek(l + this.streamOffset);
    }

    private void writeProlog() throws IOException {
        DataAtom dataAtom = new DataAtom("ftyp");
        DataAtomOutputStream dataAtomOutputStream = dataAtom.getOutputStream();
        dataAtomOutputStream.writeType("qt  ");
        dataAtomOutputStream.writeBCD4(2005);
        dataAtomOutputStream.writeBCD2(3);
        dataAtomOutputStream.writeBCD2(0);
        dataAtomOutputStream.writeType("qt  ");
        dataAtomOutputStream.writeInt(0);
        dataAtomOutputStream.writeInt(0);
        dataAtomOutputStream.writeInt(0);
        dataAtom.finish();
    }

    private void writeEpilog() throws IOException {
        Date date = new Date();
        long l = this.getMovieDuration();
        this.moovAtom = new CompositeAtom("moov");
        DataAtom dataAtom = new DataAtom("mvhd");
        this.moovAtom.add(dataAtom);
        DataAtomOutputStream dataAtomOutputStream = dataAtom.getOutputStream();
        dataAtomOutputStream.writeByte(0);
        dataAtomOutputStream.writeByte(0);
        dataAtomOutputStream.writeByte(0);
        dataAtomOutputStream.writeByte(0);
        dataAtomOutputStream.writeMacTimestamp(this.creationTime);
        dataAtomOutputStream.writeMacTimestamp(date);
        dataAtomOutputStream.writeUInt(this.movieTimeScale);
        dataAtomOutputStream.writeUInt(l);
        dataAtomOutputStream.writeFixed16D16(1.0);
        dataAtomOutputStream.writeShort(256);
        dataAtomOutputStream.write(new byte[10]);
        dataAtomOutputStream.writeFixed16D16(1.0);
        dataAtomOutputStream.writeFixed16D16(0.0);
        dataAtomOutputStream.writeFixed2D30(0.0);
        dataAtomOutputStream.writeFixed16D16(0.0);
        dataAtomOutputStream.writeFixed16D16(1.0);
        dataAtomOutputStream.writeFixed2D30(0.0);
        dataAtomOutputStream.writeFixed16D16(0.0);
        dataAtomOutputStream.writeFixed16D16(0.0);
        dataAtomOutputStream.writeFixed2D30(1.0);
        dataAtomOutputStream.writeInt(0);
        dataAtomOutputStream.writeInt(0);
        dataAtomOutputStream.writeInt(0);
        dataAtomOutputStream.writeInt(0);
        dataAtomOutputStream.writeInt(0);
        dataAtomOutputStream.writeInt(0);
        dataAtomOutputStream.writeUInt(this.tracks.size() + 1);
        int n = 0;
        int n2 = this.tracks.size();
        while (n < n2) {
            Track track = this.tracks.get(n);
            track.writeTrackAtoms(n, this.moovAtom, date);
            ++n;
        }
        this.moovAtom.finish();
    }

    public void toWebOptimizedMovie(File file, boolean bl) throws IOException {
        this.finish();
        long l = this.mdatAtom.getOffset();
        CompositeAtom compositeAtom = this.moovAtom;
        this.mdatOffset = 0L;
        ImageOutputStream imageOutputStream = this.out;
        try {
            Object object;
            this.out = null;
            if (bl) {
                FilterOutputStream filterOutputStream;
                object = new ByteArrayOutputStream();
                int n = 5;
                long l2 = 48L;
                long l3 = 0L;
                long l4 = 0L;
                while (true) {
                    this.mdatOffset = l2 + l3 + l4;
                    ((ByteArrayOutputStream)object).reset();
                    filterOutputStream = new DeflaterOutputStream((OutputStream)object);
                    this.out = new MemoryCacheImageOutputStream(filterOutputStream);
                    this.writeEpilog();
                    this.out.close();
                    ((DeflaterOutputStream)filterOutputStream).close();
                    if ((long)((ByteArrayOutputStream)object).size() <= l3 + l4 || --n <= 0) break;
                    if (l3 != 0L) {
                        l4 = Math.max(l4, (long)((ByteArrayOutputStream)object).size() - l3 - l4);
                    }
                    l3 = ((ByteArrayOutputStream)object).size();
                }
                l4 = l3 + l4 - (long)((ByteArrayOutputStream)object).size();
                l3 = ((ByteArrayOutputStream)object).size();
                if (n < 0 || ((ByteArrayOutputStream)object).size() == 0) {
                    bl = false;
                    System.err.println("WARNING QuickTimeWriter failed to compress header.");
                } else {
                    this.out = new FileImageOutputStream(file);
                    this.writeProlog();
                    filterOutputStream = new DataAtomOutputStream(new ImageOutputStreamAdapter(this.out));
                    ((DataAtomOutputStream)filterOutputStream).writeUInt(l3 + 40L);
                    ((DataAtomOutputStream)filterOutputStream).writeType("moov");
                    ((DataAtomOutputStream)filterOutputStream).writeUInt(l3 + 32L);
                    ((DataAtomOutputStream)filterOutputStream).writeType("cmov");
                    ((DataAtomOutputStream)filterOutputStream).writeUInt(12L);
                    ((DataAtomOutputStream)filterOutputStream).writeType("dcom");
                    ((DataAtomOutputStream)filterOutputStream).writeType("zlib");
                    ((DataAtomOutputStream)filterOutputStream).writeUInt(l3 + 12L);
                    ((DataAtomOutputStream)filterOutputStream).writeType("cmvd");
                    ((DataAtomOutputStream)filterOutputStream).writeUInt(compositeAtom.size());
                    filterOutputStream.write(((ByteArrayOutputStream)object).toByteArray());
                    ((DataAtomOutputStream)filterOutputStream).writeUInt(l4 + 8L);
                    ((DataAtomOutputStream)filterOutputStream).writeType("free");
                    int n2 = 0;
                    while ((long)n2 < l4) {
                        ((DataAtomOutputStream)filterOutputStream).write(0);
                        ++n2;
                    }
                }
            }
            if (!bl) {
                this.out = new FileImageOutputStream(file);
                this.mdatOffset = this.moovAtom.size();
                this.writeProlog();
                this.writeEpilog();
            }
            object = new byte[4096];
            imageOutputStream.seek(l);
            long l5 = 0L;
            long l6 = this.mdatAtom.size();
            while (l5 < l6) {
                int n = imageOutputStream.read((byte[])object, 0, (int)Math.min((long)((Object)object).length, l6 - l5));
                this.out.write((byte[])object, 0, n);
                l5 += (long)n;
            }
            this.out.close();
        }
        finally {
            this.mdatOffset = 0L;
            this.moovAtom = compositeAtom;
            this.out = imageOutputStream;
        }
    }

    private abstract class Atom {
        protected String type;
        protected long offset;

        public Atom(String string) throws IOException {
            this.type = string;
            this.offset = QuickTimeWriter.this.getRelativeStreamPosition();
        }

        public abstract void finish() throws IOException;

        public abstract long size();
    }

    private class AudioTrack
    extends Track {
        private int soundNumberOfChannels;
        private int soundSampleSize;
        private int soundCompressionId;
        private long soundSamplesPerPacket;
        private int soundBytesPerPacket;
        private int soundBytesPerFrame;
        private int soundBytesPerSample;
        private double soundSampleRate;
        private byte[] stsdExtensions;

        public AudioTrack() {
            super(MediaType.AUDIO);
            this.stsdExtensions = new byte[0];
        }

        @Override
        protected void writeMediaInformationHeaderAtom(CompositeAtom compositeAtom) throws IOException {
            DataAtom dataAtom = new DataAtom("smhd");
            compositeAtom.add(dataAtom);
            DataAtomOutputStream dataAtomOutputStream = dataAtom.getOutputStream();
            dataAtomOutputStream.write(0);
            dataAtomOutputStream.write(0);
            dataAtomOutputStream.write(0);
            dataAtomOutputStream.write(0);
            dataAtomOutputStream.writeFixed8D8(0.0f);
            dataAtomOutputStream.writeUShort(0);
        }

        @Override
        protected void writeSampleDescriptionAtom(CompositeAtom compositeAtom) throws IOException {
            DataAtom dataAtom = new DataAtom("stsd");
            compositeAtom.add(dataAtom);
            DataAtomOutputStream dataAtomOutputStream = dataAtom.getOutputStream();
            dataAtomOutputStream.write(0);
            dataAtomOutputStream.write(0);
            dataAtomOutputStream.write(0);
            dataAtomOutputStream.write(0);
            dataAtomOutputStream.writeInt(1);
            dataAtomOutputStream.writeUInt(52 + this.stsdExtensions.length);
            dataAtomOutputStream.writeType(this.mediaCompressionType);
            dataAtomOutputStream.write(new byte[6]);
            dataAtomOutputStream.writeUShort(1);
            dataAtomOutputStream.writeUShort(1);
            dataAtomOutputStream.writeUShort(0);
            dataAtomOutputStream.writeUInt(0L);
            dataAtomOutputStream.writeUShort(this.soundNumberOfChannels);
            dataAtomOutputStream.writeUShort(this.soundSampleSize);
            dataAtomOutputStream.writeUShort(this.soundCompressionId);
            dataAtomOutputStream.writeUShort(0);
            dataAtomOutputStream.writeFixed16D16(this.soundSampleRate);
            dataAtomOutputStream.writeUInt(this.soundSamplesPerPacket);
            dataAtomOutputStream.writeUInt(this.soundBytesPerPacket);
            dataAtomOutputStream.writeUInt(this.soundBytesPerFrame);
            dataAtomOutputStream.writeUInt(this.soundBytesPerSample);
            dataAtomOutputStream.write(this.stsdExtensions);
        }
    }

    private static class Chunk
    extends Group {
        private int sampleDescriptionId;

        public Chunk(Sample sample, int n) {
            super(sample);
            this.sampleDescriptionId = n;
        }

        public Chunk(Sample sample, Sample sample2, int n, int n2) {
            super(sample, sample2, n);
            this.sampleDescriptionId = n2;
        }

        public boolean maybeAddSample(Sample sample, int n) {
            if (n == this.sampleDescriptionId && this.lastSample.offset + this.lastSample.length == sample.offset) {
                return super.maybeAddSample(sample);
            }
            return false;
        }

        @Override
        public boolean maybeAddChunk(Chunk chunk) {
            if (this.sampleDescriptionId == chunk.sampleDescriptionId && this.lastSample.offset + this.lastSample.length == chunk.firstSample.offset) {
                return super.maybeAddChunk(chunk);
            }
            return false;
        }

        public long getChunkOffset() {
            return this.firstSample.offset;
        }
    }

    private class CompositeAtom
    extends DataAtom {
        private LinkedList<Atom> children;

        public CompositeAtom(String string) throws IOException {
            super(string);
            this.children = new LinkedList();
        }

        public void add(Atom atom) throws IOException {
            if (this.children.size() > 0) {
                this.children.getLast().finish();
            }
            this.children.add(atom);
        }

        @Override
        public void finish() throws IOException {
            if (!this.finished) {
                if (this.size() > 0xFFFFFFFFL) {
                    throw new IOException("CompositeAtom \"" + this.type + "\" is too large: " + this.size());
                }
                long l = QuickTimeWriter.this.getRelativeStreamPosition();
                QuickTimeWriter.this.seekRelative(this.offset);
                DataAtomOutputStream dataAtomOutputStream = new DataAtomOutputStream(new ImageOutputStreamAdapter(QuickTimeWriter.this.out));
                dataAtomOutputStream.writeInt((int)this.size());
                dataAtomOutputStream.writeType(this.type);
                for (Atom atom : this.children) {
                    atom.finish();
                }
                QuickTimeWriter.this.seekRelative(l);
                this.finished = true;
            }
        }

        @Override
        public long size() {
            long l = 8L + this.data.size();
            for (Atom atom : this.children) {
                l += atom.size();
            }
            return l;
        }
    }

    private class DataAtom
    extends Atom {
        protected DataAtomOutputStream data;
        protected boolean finished;

        public DataAtom(String string) throws IOException {
            super(string);
            QuickTimeWriter.this.out.writeLong(0L);
            this.data = new DataAtomOutputStream(new ImageOutputStreamAdapter(QuickTimeWriter.this.out));
        }

        public DataAtomOutputStream getOutputStream() {
            if (this.finished) {
                throw new IllegalStateException("DataAtom is finished");
            }
            return this.data;
        }

        @Override
        public void finish() throws IOException {
            if (!this.finished) {
                long l = this.size();
                if (this.size() > 0xFFFFFFFFL) {
                    throw new IOException("DataAtom \"" + this.type + "\" is too large: " + this.size());
                }
                long l2 = QuickTimeWriter.this.getRelativeStreamPosition();
                QuickTimeWriter.this.seekRelative(this.offset);
                DataAtomOutputStream dataAtomOutputStream = new DataAtomOutputStream(new ImageOutputStreamAdapter(QuickTimeWriter.this.out));
                dataAtomOutputStream.writeUInt(this.size());
                dataAtomOutputStream.writeType(this.type);
                QuickTimeWriter.this.seekRelative(l2);
                this.finished = true;
                long l3 = this.size();
                if (l != l3) {
                    System.err.println("size mismatch " + l + ".." + l3);
                }
            }
        }

        @Override
        public long size() {
            return 8L + this.data.size();
        }
    }

    public static class Edit {
        public int trackDuration;
        public int mediaTime;
        public int mediaRate;

        public Edit(int n, int n2, double d) {
            if (n < 0) {
                throw new IllegalArgumentException("trackDuration must not be < 0:" + n);
            }
            if (n2 < -1) {
                throw new IllegalArgumentException("mediaTime must not be < -1:" + n2);
            }
            if (d <= 0.0) {
                throw new IllegalArgumentException("mediaRate must not be <= 0:" + d);
            }
            this.trackDuration = n;
            this.mediaTime = n2;
            this.mediaRate = (int)(d * 65536.0);
        }

        public Edit(int n, int n2, int n3) {
            if (n < 0) {
                throw new IllegalArgumentException("trackDuration must not be < 0:" + n);
            }
            if (n2 < -1) {
                throw new IllegalArgumentException("mediaTime must not be < -1:" + n2);
            }
            if (n3 <= 0) {
                throw new IllegalArgumentException("mediaRate must not be <= 0:" + n3);
            }
            this.trackDuration = n;
            this.mediaTime = n2;
            this.mediaRate = n3;
        }
    }

    private static abstract class Group {
        protected Sample firstSample;
        protected Sample lastSample;
        protected long sampleCount;
        private static final long maxSampleCount = Integer.MAX_VALUE;

        protected Group(Sample sample) {
            this.firstSample = this.lastSample = sample;
            this.sampleCount = 1L;
        }

        protected Group(Sample sample, Sample sample2, long l) {
            this.firstSample = sample;
            this.lastSample = sample2;
            this.sampleCount = l;
            if (l > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Capacity exceeded");
            }
        }

        protected Group(Group group) {
            this.firstSample = group.firstSample;
            this.lastSample = group.lastSample;
            this.sampleCount = group.sampleCount;
        }

        protected boolean maybeAddSample(Sample sample) {
            if (this.sampleCount < Integer.MAX_VALUE) {
                this.lastSample = sample;
                ++this.sampleCount;
                return true;
            }
            return false;
        }

        protected boolean maybeAddChunk(Chunk chunk) {
            if (this.sampleCount + chunk.sampleCount <= Integer.MAX_VALUE) {
                this.lastSample = chunk.lastSample;
                this.sampleCount += chunk.sampleCount;
                return true;
            }
            return false;
        }

        public long getSampleCount() {
            return this.sampleCount;
        }
    }

    private static enum MediaType {
        VIDEO,
        AUDIO;

    }

    private static class Sample {
        long offset;
        long length;
        long duration;

        public Sample(long l, long l2, long l3) {
            this.duration = l;
            this.offset = l2;
            this.length = l3;
        }
    }

    private static class SampleSizeGroup
    extends Group {
        public SampleSizeGroup(Sample sample) {
            super(sample);
        }

        public SampleSizeGroup(Group group) {
            super(group);
        }

        @Override
        public boolean maybeAddSample(Sample sample) {
            if (this.firstSample.length == sample.length) {
                return super.maybeAddSample(sample);
            }
            return false;
        }

        @Override
        public boolean maybeAddChunk(Chunk chunk) {
            if (this.firstSample.length == chunk.firstSample.length) {
                return super.maybeAddChunk(chunk);
            }
            return false;
        }

        public long getSampleLength() {
            return this.firstSample.length;
        }
    }

    private static enum States {
        REALIZED,
        STARTED,
        FINISHED,
        CLOSED;

    }

    private static class TimeToSampleGroup
    extends Group {
        public TimeToSampleGroup(Sample sample) {
            super(sample);
        }

        public TimeToSampleGroup(Group group) {
            super(group);
        }

        @Override
        public boolean maybeAddSample(Sample sample) {
            if (this.firstSample.duration == sample.duration) {
                return super.maybeAddSample(sample);
            }
            return false;
        }

        @Override
        public boolean maybeAddChunk(Chunk chunk) {
            if (this.firstSample.duration == chunk.firstSample.duration) {
                return super.maybeAddChunk(chunk);
            }
            return false;
        }

        public long getSampleDuration() {
            return this.firstSample.duration;
        }
    }

    private abstract class Track {
        final MediaType mediaType;
        protected long mediaTimeScale = 600L;
        protected String mediaCompressionType;
        protected String mediaCompressorName;
        protected ArrayList<Chunk> chunks = new ArrayList();
        protected ArrayList<TimeToSampleGroup> timeToSamples = new ArrayList();
        protected ArrayList<SampleSizeGroup> sampleSizes = new ArrayList();
        protected ArrayList<Long> syncSamples = null;
        protected long sampleCount = 0L;
        protected long mediaDuration = 0L;
        protected Edit[] editList;

        public Track(MediaType mediaType) {
            this.mediaType = mediaType;
        }

        public void addSample(Sample sample, int n, boolean bl) {
            this.mediaDuration += sample.duration;
            ++this.sampleCount;
            if (bl) {
                if (this.syncSamples != null) {
                    this.syncSamples.add(this.sampleCount);
                }
            } else if (this.syncSamples == null) {
                this.syncSamples = new ArrayList();
                long l = 1L;
                while (l < this.sampleCount) {
                    this.syncSamples.add(l);
                    ++l;
                }
            }
            if (this.timeToSamples.isEmpty() || !this.timeToSamples.get(this.timeToSamples.size() - 1).maybeAddSample(sample)) {
                this.timeToSamples.add(new TimeToSampleGroup(sample));
            }
            if (this.sampleSizes.isEmpty() || !this.sampleSizes.get(this.sampleSizes.size() - 1).maybeAddSample(sample)) {
                this.sampleSizes.add(new SampleSizeGroup(sample));
            }
            if (this.chunks.isEmpty() || !this.chunks.get(this.chunks.size() - 1).maybeAddSample(sample, n)) {
                this.chunks.add(new Chunk(sample, n));
            }
        }

        public void addChunk(Chunk chunk, boolean bl) {
            this.mediaDuration += chunk.firstSample.duration * chunk.sampleCount;
            this.sampleCount += chunk.sampleCount;
            if (this.timeToSamples.isEmpty() || !this.timeToSamples.get(this.timeToSamples.size() - 1).maybeAddChunk(chunk)) {
                this.timeToSamples.add(new TimeToSampleGroup(chunk));
            }
            if (this.sampleSizes.isEmpty() || !this.sampleSizes.get(this.sampleSizes.size() - 1).maybeAddChunk(chunk)) {
                this.sampleSizes.add(new SampleSizeGroup(chunk));
            }
            if (this.chunks.isEmpty() || !this.chunks.get(this.chunks.size() - 1).maybeAddChunk(chunk)) {
                this.chunks.add(chunk);
            }
        }

        public long getSampleCount() {
            return this.sampleCount;
        }

        public long getTrackDuration(long l) {
            if (this.editList == null || this.editList.length == 0) {
                return this.mediaDuration * l / this.mediaTimeScale;
            }
            long l2 = 0L;
            int n = 0;
            while (n < this.editList.length) {
                l2 += (long)this.editList[n].trackDuration;
                ++n;
            }
            return l2;
        }

        private void writeTrackAtoms(int n, CompositeAtom compositeAtom, Date date) throws IOException {
            CompositeAtom compositeAtom2 = new CompositeAtom("trak");
            compositeAtom.add(compositeAtom2);
            DataAtom dataAtom = new DataAtom("tkhd");
            compositeAtom2.add(dataAtom);
            DataAtomOutputStream dataAtomOutputStream = dataAtom.getOutputStream();
            dataAtomOutputStream.write(0);
            dataAtomOutputStream.write(0);
            dataAtomOutputStream.write(0);
            dataAtomOutputStream.write(15);
            dataAtomOutputStream.writeMacTimestamp(QuickTimeWriter.this.creationTime);
            dataAtomOutputStream.writeMacTimestamp(date);
            dataAtomOutputStream.writeInt(n + 1);
            dataAtomOutputStream.writeInt(0);
            dataAtomOutputStream.writeUInt(this.getTrackDuration(QuickTimeWriter.this.movieTimeScale));
            dataAtomOutputStream.writeLong(0L);
            dataAtomOutputStream.writeShort(0);
            dataAtomOutputStream.writeShort(0);
            dataAtomOutputStream.writeFixed8D8(this.mediaType == MediaType.AUDIO ? 1 : 0);
            dataAtomOutputStream.writeShort(0);
            dataAtomOutputStream.writeFixed16D16(1.0);
            dataAtomOutputStream.writeFixed16D16(0.0);
            dataAtomOutputStream.writeFixed2D30(0.0);
            dataAtomOutputStream.writeFixed16D16(0.0);
            dataAtomOutputStream.writeFixed16D16(1.0);
            dataAtomOutputStream.writeFixed2D30(0.0);
            dataAtomOutputStream.writeFixed16D16(0.0);
            dataAtomOutputStream.writeFixed16D16(0.0);
            dataAtomOutputStream.writeFixed2D30(1.0);
            dataAtomOutputStream.writeFixed16D16(this.mediaType == MediaType.VIDEO ? ((VideoTrack)this).videoWidth : 0);
            dataAtomOutputStream.writeFixed16D16(this.mediaType == MediaType.VIDEO ? ((VideoTrack)this).videoHeight : 0);
            CompositeAtom compositeAtom3 = new CompositeAtom("edts");
            compositeAtom2.add(compositeAtom3);
            dataAtom = new DataAtom("elst");
            compositeAtom3.add(dataAtom);
            dataAtomOutputStream = dataAtom.getOutputStream();
            dataAtomOutputStream.write(0);
            dataAtomOutputStream.write(0);
            dataAtomOutputStream.write(0);
            dataAtomOutputStream.write(0);
            Edit[] editArray = this.editList;
            if (editArray == null || editArray.length == 0) {
                dataAtomOutputStream.writeUInt(1L);
                dataAtomOutputStream.writeUInt(this.getTrackDuration(QuickTimeWriter.this.movieTimeScale));
                dataAtomOutputStream.writeUInt(0L);
                dataAtomOutputStream.writeFixed16D16(1.0);
            } else {
                dataAtomOutputStream.writeUInt(editArray.length);
                int n2 = 0;
                while (n2 < editArray.length) {
                    dataAtomOutputStream.writeUInt(editArray[n2].trackDuration);
                    dataAtomOutputStream.writeUInt(editArray[n2].mediaTime);
                    dataAtomOutputStream.writeUInt(editArray[n2].mediaRate);
                    ++n2;
                }
            }
            CompositeAtom compositeAtom4 = new CompositeAtom("mdia");
            compositeAtom2.add(compositeAtom4);
            dataAtom = new DataAtom("mdhd");
            compositeAtom4.add(dataAtom);
            dataAtomOutputStream = dataAtom.getOutputStream();
            dataAtomOutputStream.write(0);
            dataAtomOutputStream.write(0);
            dataAtomOutputStream.write(0);
            dataAtomOutputStream.write(0);
            dataAtomOutputStream.writeMacTimestamp(QuickTimeWriter.this.creationTime);
            dataAtomOutputStream.writeMacTimestamp(date);
            dataAtomOutputStream.writeUInt(this.mediaTimeScale);
            dataAtomOutputStream.writeUInt(this.mediaDuration);
            dataAtomOutputStream.writeShort(0);
            dataAtomOutputStream.writeShort(0);
            dataAtom = new DataAtom("hdlr");
            compositeAtom4.add(dataAtom);
            dataAtomOutputStream = dataAtom.getOutputStream();
            dataAtomOutputStream.write(0);
            dataAtomOutputStream.write(0);
            dataAtomOutputStream.write(0);
            dataAtomOutputStream.write(0);
            dataAtomOutputStream.writeType("mhlr");
            dataAtomOutputStream.writeType(this.mediaType == MediaType.VIDEO ? "vide" : "soun");
            if (this.mediaType == MediaType.AUDIO) {
                dataAtomOutputStream.writeType("appl");
            } else {
                dataAtomOutputStream.writeUInt(0L);
            }
            dataAtomOutputStream.writeUInt(this.mediaType == MediaType.AUDIO ? 0x10000000L : 0L);
            dataAtomOutputStream.writeUInt(this.mediaType == MediaType.AUDIO ? 65941 : 0);
            dataAtomOutputStream.writePString(this.mediaType == MediaType.AUDIO ? "Apple Sound Media Handler" : "");
            this.writeMediaInformationAtoms(compositeAtom4);
        }

        private void writeMediaInformationAtoms(CompositeAtom compositeAtom) throws IOException {
            CompositeAtom compositeAtom2 = new CompositeAtom("minf");
            compositeAtom.add(compositeAtom2);
            this.writeMediaInformationHeaderAtom(compositeAtom2);
            DataAtom dataAtom = new DataAtom("hdlr");
            compositeAtom2.add(dataAtom);
            DataAtomOutputStream dataAtomOutputStream = dataAtom.getOutputStream();
            dataAtomOutputStream.write(0);
            dataAtomOutputStream.write(0);
            dataAtomOutputStream.write(0);
            dataAtomOutputStream.write(0);
            dataAtomOutputStream.writeType("dhlr");
            dataAtomOutputStream.writeType("alis");
            if (this.mediaType == MediaType.AUDIO) {
                dataAtomOutputStream.writeType("appl");
            } else {
                dataAtomOutputStream.writeUInt(0L);
            }
            dataAtomOutputStream.writeUInt(this.mediaType == MediaType.AUDIO ? 0x10000001L : 0L);
            dataAtomOutputStream.writeInt(this.mediaType == MediaType.AUDIO ? 65967 : 0);
            dataAtomOutputStream.writePString("Apple Alias Data Handler");
            CompositeAtom compositeAtom3 = new CompositeAtom("dinf");
            compositeAtom2.add(compositeAtom3);
            dataAtom = new DataAtom("dref");
            compositeAtom3.add(dataAtom);
            dataAtomOutputStream = dataAtom.getOutputStream();
            dataAtomOutputStream.write(0);
            dataAtomOutputStream.write(0);
            dataAtomOutputStream.write(0);
            dataAtomOutputStream.write(0);
            dataAtomOutputStream.writeInt(1);
            dataAtomOutputStream.writeInt(12);
            dataAtomOutputStream.writeType("alis");
            dataAtomOutputStream.write(0);
            dataAtomOutputStream.write(0);
            dataAtomOutputStream.write(0);
            dataAtomOutputStream.write(1);
            this.writeSampleTableAtoms(compositeAtom2);
        }

        protected abstract void writeMediaInformationHeaderAtom(CompositeAtom var1) throws IOException;

        protected abstract void writeSampleDescriptionAtom(CompositeAtom var1) throws IOException;

        private void writeSampleTableAtoms(CompositeAtom compositeAtom) throws IOException {
            int n;
            CompositeAtom compositeAtom2 = new CompositeAtom("stbl");
            compositeAtom.add(compositeAtom2);
            this.writeSampleDescriptionAtom(compositeAtom2);
            DataAtom dataAtom = new DataAtom("stts");
            compositeAtom2.add(dataAtom);
            DataAtomOutputStream dataAtomOutputStream = dataAtom.getOutputStream();
            dataAtomOutputStream.write(0);
            dataAtomOutputStream.write(0);
            dataAtomOutputStream.write(0);
            dataAtomOutputStream.write(0);
            dataAtomOutputStream.writeUInt(this.timeToSamples.size());
            for (TimeToSampleGroup timeToSampleGroup : this.timeToSamples) {
                dataAtomOutputStream.writeUInt(timeToSampleGroup.getSampleCount());
                dataAtomOutputStream.writeUInt(timeToSampleGroup.getSampleDuration());
            }
            dataAtom = new DataAtom("stsc");
            compositeAtom2.add(dataAtom);
            dataAtomOutputStream = dataAtom.getOutputStream();
            dataAtomOutputStream.write(0);
            dataAtomOutputStream.write(0);
            dataAtomOutputStream.write(0);
            dataAtomOutputStream.write(0);
            int n2 = 0;
            long l = -1L;
            long l2 = -1L;
            for (Chunk chunk : this.chunks) {
                if (chunk.sampleCount == l && (long)chunk.sampleDescriptionId == l2) continue;
                l = chunk.sampleCount;
                l2 = chunk.sampleDescriptionId;
                ++n2;
            }
            dataAtomOutputStream.writeInt(n2);
            int n3 = 1;
            l = -1L;
            l2 = -1L;
            for (Chunk chunk : this.chunks) {
                if (chunk.sampleCount != l || (long)chunk.sampleDescriptionId != l2) {
                    l = chunk.sampleCount;
                    l2 = chunk.sampleDescriptionId;
                    dataAtomOutputStream.writeUInt(n3);
                    dataAtomOutputStream.writeUInt(chunk.sampleCount);
                    dataAtomOutputStream.writeInt(chunk.sampleDescriptionId);
                }
                ++n3;
            }
            if (this.syncSamples != null) {
                dataAtom = new DataAtom("stss");
                compositeAtom2.add(dataAtom);
                dataAtomOutputStream = dataAtom.getOutputStream();
                dataAtomOutputStream.write(0);
                dataAtomOutputStream.write(0);
                dataAtomOutputStream.write(0);
                dataAtomOutputStream.write(0);
                dataAtomOutputStream.writeUInt(this.syncSamples.size());
                for (Long l3 : this.syncSamples) {
                    dataAtomOutputStream.writeUInt(l3);
                }
            }
            dataAtom = new DataAtom("stsz");
            compositeAtom2.add(dataAtom);
            dataAtomOutputStream = dataAtom.getOutputStream();
            dataAtomOutputStream.write(0);
            dataAtomOutputStream.write(0);
            dataAtomOutputStream.write(0);
            dataAtomOutputStream.write(0);
            int n4 = n = this.mediaType == MediaType.AUDIO && ((AudioTrack)this).soundCompressionId != -2 ? ((AudioTrack)this).soundSampleSize / 8 * ((AudioTrack)this).soundNumberOfChannels : 1;
            if (this.sampleSizes.size() == 1) {
                dataAtomOutputStream.writeUInt(this.sampleSizes.get(0).getSampleLength() / (long)n);
                dataAtomOutputStream.writeUInt(this.sampleSizes.get(0).getSampleCount());
            } else {
                dataAtomOutputStream.writeUInt(0L);
                long l4 = 0L;
                for (SampleSizeGroup sampleSizeGroup : this.sampleSizes) {
                    l4 += sampleSizeGroup.sampleCount;
                }
                dataAtomOutputStream.writeUInt(l4);
                for (SampleSizeGroup sampleSizeGroup : this.sampleSizes) {
                    long l5 = sampleSizeGroup.getSampleLength() / (long)n;
                    int n5 = 0;
                    while ((long)n5 < sampleSizeGroup.sampleCount) {
                        dataAtomOutputStream.writeUInt(l5);
                        ++n5;
                    }
                }
            }
            if (this.chunks.isEmpty() || this.chunks.get(this.chunks.size() - 1).getChunkOffset() <= 0xFFFFFFFFL) {
                dataAtom = new DataAtom("stco");
                compositeAtom2.add(dataAtom);
                dataAtomOutputStream = dataAtom.getOutputStream();
                dataAtomOutputStream.write(0);
                dataAtomOutputStream.write(0);
                dataAtomOutputStream.write(0);
                dataAtomOutputStream.write(0);
                dataAtomOutputStream.writeUInt(this.chunks.size());
                for (Chunk chunk : this.chunks) {
                    dataAtomOutputStream.writeUInt(chunk.getChunkOffset() + QuickTimeWriter.this.mdatOffset);
                }
            } else {
                dataAtom = new DataAtom("co64");
                compositeAtom2.add(dataAtom);
                dataAtomOutputStream = dataAtom.getOutputStream();
                dataAtomOutputStream.write(0);
                dataAtomOutputStream.write(0);
                dataAtomOutputStream.write(0);
                dataAtomOutputStream.write(0);
                dataAtomOutputStream.writeUInt(this.chunks.size());
                for (Chunk chunk : this.chunks) {
                    dataAtomOutputStream.writeLong(chunk.getChunkOffset());
                }
            }
        }
    }

    public static enum VideoFormat {
        RAW("raw ", "None", true),
        JPG("jpeg", "Photo - JPEG", true),
        PNG("png ", "PNG", true),
        RLE("rle ", "Animation", false);

        private String compressionType;
        private String compressorName;
        private boolean allSamplesAreSyncSamples;

        private VideoFormat(String string2, String string3, boolean bl) {
            this.compressionType = string2;
            this.compressorName = string3;
            this.allSamplesAreSyncSamples = bl;
        }
    }

    private class VideoTrack
    extends Track {
        private VideoFormat videoEncoding;
        private float videoQuality;
        private int videoWidth;
        private int videoHeight;
        private int videoDepth;
        private IndexColorModel videoColorTable;
        private AppleRLEEncoder encoder;
        private Object previousData;
        private int syncInterval;

        public VideoTrack() {
            super(MediaType.VIDEO);
            this.videoQuality = 0.97f;
            this.videoWidth = -1;
            this.videoHeight = -1;
            this.videoDepth = -1;
        }

        @Override
        protected void writeMediaInformationHeaderAtom(CompositeAtom compositeAtom) throws IOException {
            DataAtom dataAtom = new DataAtom("vmhd");
            compositeAtom.add(dataAtom);
            DataAtomOutputStream dataAtomOutputStream = dataAtom.getOutputStream();
            dataAtomOutputStream.write(0);
            dataAtomOutputStream.write(0);
            dataAtomOutputStream.write(0);
            dataAtomOutputStream.write(1);
            dataAtomOutputStream.writeShort(64);
            dataAtomOutputStream.writeUShort(0);
            dataAtomOutputStream.writeUShort(0);
            dataAtomOutputStream.writeUShort(0);
        }

        @Override
        protected void writeSampleDescriptionAtom(CompositeAtom compositeAtom) throws IOException {
            CompositeAtom compositeAtom2 = new CompositeAtom("stsd");
            compositeAtom.add(compositeAtom2);
            DataAtomOutputStream dataAtomOutputStream = compositeAtom2.getOutputStream();
            dataAtomOutputStream.write(0);
            dataAtomOutputStream.write(0);
            dataAtomOutputStream.write(0);
            dataAtomOutputStream.write(0);
            dataAtomOutputStream.writeInt(1);
            dataAtomOutputStream.writeInt(98);
            dataAtomOutputStream.writeType(this.mediaCompressionType);
            dataAtomOutputStream.write(new byte[6]);
            dataAtomOutputStream.writeShort(1);
            dataAtomOutputStream.writeShort(0);
            dataAtomOutputStream.writeShort(0);
            dataAtomOutputStream.writeType("java");
            dataAtomOutputStream.writeInt(0);
            dataAtomOutputStream.writeInt(512);
            dataAtomOutputStream.writeUShort(this.videoWidth);
            dataAtomOutputStream.writeUShort(this.videoHeight);
            dataAtomOutputStream.writeFixed16D16(72.0);
            dataAtomOutputStream.writeFixed16D16(72.0);
            dataAtomOutputStream.writeInt(0);
            dataAtomOutputStream.writeShort(1);
            dataAtomOutputStream.writePString(this.mediaCompressorName, 32);
            dataAtomOutputStream.writeShort(this.videoDepth);
            dataAtomOutputStream.writeShort(this.videoColorTable == null ? -1 : 0);
            if (this.videoColorTable != null) {
                this.writeColorTableAtom(compositeAtom2);
            }
            this.writeGammaAtom(compositeAtom2);
        }

        protected void writeGammaAtom(CompositeAtom compositeAtom) throws IOException {
            DataAtom dataAtom = new DataAtom("gama");
            compositeAtom.add(dataAtom);
            DataAtomOutputStream dataAtomOutputStream = dataAtom.getOutputStream();
            dataAtomOutputStream.writeFixed16D16(2.2);
        }

        protected void writeColorTableAtom(CompositeAtom compositeAtom) throws IOException {
            DataAtom dataAtom = new DataAtom("ctab");
            compositeAtom.add(dataAtom);
            DataAtomOutputStream dataAtomOutputStream = dataAtom.getOutputStream();
            dataAtomOutputStream.writeUInt(0L);
            dataAtomOutputStream.writeUShort(32768);
            dataAtomOutputStream.writeUShort(this.videoColorTable.getMapSize() - 1);
            int n = 0;
            int n2 = this.videoColorTable.getMapSize();
            while (n < n2) {
                dataAtomOutputStream.writeUShort(0);
                dataAtomOutputStream.writeUShort(this.videoColorTable.getRed(n) << 8 | this.videoColorTable.getRed(n));
                dataAtomOutputStream.writeUShort(this.videoColorTable.getGreen(n) << 8 | this.videoColorTable.getGreen(n));
                dataAtomOutputStream.writeUShort(this.videoColorTable.getBlue(n) << 8 | this.videoColorTable.getBlue(n));
                ++n;
            }
        }
    }

    private class WideDataAtom
    extends Atom {
        private DataAtomOutputStream data;
        private boolean finished;

        public WideDataAtom(String string) throws IOException {
            super(string);
            QuickTimeWriter.this.out.writeLong(0L);
            QuickTimeWriter.this.out.writeLong(0L);
            this.data = new DataAtomOutputStream(new ImageOutputStreamAdapter(QuickTimeWriter.this.out)){

                @Override
                public void flush() throws IOException {
                }
            };
        }

        public DataAtomOutputStream getOutputStream() {
            if (this.finished) {
                throw new IllegalStateException("Atom is finished");
            }
            return this.data;
        }

        public long getOffset() {
            return this.offset;
        }

        @Override
        public void finish() throws IOException {
            if (!this.finished) {
                long l = QuickTimeWriter.this.getRelativeStreamPosition();
                QuickTimeWriter.this.seekRelative(this.offset);
                DataAtomOutputStream dataAtomOutputStream = new DataAtomOutputStream(new ImageOutputStreamAdapter(QuickTimeWriter.this.out));
                long l2 = this.size();
                if (l2 <= 0xFFFFFFFFL) {
                    dataAtomOutputStream.writeUInt(8L);
                    dataAtomOutputStream.writeType("wide");
                    dataAtomOutputStream.writeUInt(l2 - 8L);
                    dataAtomOutputStream.writeType(this.type);
                } else {
                    dataAtomOutputStream.writeInt(1);
                    dataAtomOutputStream.writeType(this.type);
                    dataAtomOutputStream.writeLong(l2 - 8L);
                }
                QuickTimeWriter.this.seekRelative(l);
                this.finished = true;
            }
        }

        @Override
        public long size() {
            return 16L + this.data.size();
        }
    }
}

