/*==============================================================================================
   HTML Parsing Blocks. The following vars contain HTML code to be inserted in the Register
   Today HTML pages based on the business logic, e.g., whether the registration is for a company
   or individual, whether an old serial number is needed, whether State/Region/Province is 
   required, etc.

   (C) Copyright 2000 by Autodesk, Inc.  All rights reserved.
  ==============================================================================================*/

/////////////////////////////////////////////
// LOCALIZATION RESOURCES HERE:
/////////////////////////////////////////////

/////////////////////////////////////////////
// Product Language: NOTE TO LOCALIZATION: The list below was inserted on 29 Jan 2001 and it was up to date at that point.
// You may use the codes detailed below if you are sure that these have not changed (they generally dont change), otherwise, 
// please check these before inserting the language code.
/////////////////////////////////////////////
//
//English - US and International:  (en-us)
//German:  (de)
//French:   (fr)
//Italian:   (it)
//Spanish:   (es)
//Czech:   (cs)             
//Hungarian:   (hu)
//Polish:   (pl)
//Russian:   (ru)
//Japanese:   (ja)
//Korean:   (ko)
//Traditional Chinese (Taiwan) :   (zh-tw)
//Simplified Chinese (PRC) :   (zh-cn)
//
/////////////////////////////////////////////

var xmsgProductLanguage=	"fr";

/////////////////////////////////////////////
// Software Information RESOURCES HERE:
/////////////////////////////////////////////
var xmsgProduct=	"Produit: ";
var xmsgsernum=		"Numro de srie: ";
var xmsgOsernum=	"Ancien numro de srie: ";
var xmsgOldSerialNum=	"Ancien numro de srie*:";
var xmsgNewSernum1=	"Nouveau numro de srie";
var xmsgNewSernum2=	"Nouveau numro de srie*";
var xmsgRequestCode=	"Code de requte: ";
var xmsgRegAuthCode=	"Code d'autorisation: ";
var xmsgApplicationKey=	"Cl de l'application: ";

/////////////////////////////////////////////
// Primary Rolodex RESOURCES HERE:
/////////////////////////////////////////////
var xmsgSalutation=	"Salutation:";
var xmsgFirstname=	"Prnom:*";
var xmsgFirstname2=	"Prnom:";
var xmsgLastname=	"Nom:*";
var xmsgLastname2=	"Nom:";
var xmsgCompanyName=	"Socit:*";
var xmsgCompanyName2=	"Socit:";
var xmsgPhone=		"Tlphone:*";
var xmsgPhone2=		"Tlphone:";
var xmsgFax=		"Tlcopie:";
var xmsgEmail=		"E-mail:";
var xmsgAddress=	"Adresse:*";
var xmsgAddress2=	"Adresse:";
var xmsgCity=		"Ville:*";
var xmsgCity2=		"Ville:";
var xmsgSRP=		"Etat/Rgion/Province:";
var xmsgStText=		"Etat:";
var xmsgPrText=		"Province:";
var xmsgRegText=	"Rgion:";
var xmsgZipCode=	"Code postal:";
var xmsgPostCode=	"Code postal:";
var xmsgCountry=	"Pays:";
var xmsgDealer=		"Revendeur:";
var xmsgAppUsageQ1=	"Quelle est la principale utilisation de l'application?";
var xmsgAppUsageQ2=	"Slectionnez toutes les rponses appropries:";
var xmsgAppUsage=	"Principale utilisation de l'application:";

///////////////////////////////////////////////
// Salutation RESOURCES HERE:
///////////////////////////////////////////////
var xmsgADM =    		"Adm.";
var xmsgARCH =    		"Arch.";
var xmsgARQ =    		"Arq.";
var xmsgARQA =    		"Arqa.";
var xmsgAVV =    		"Avv.";
var xmsgCA =    		"Ca.";
var xmsgCAPT =    		"Capt.";
var xmsgCOL =    		"Col.";
var xmsgCOMM =    		"Comm.";
var xmsgDHR =    		"Dhr.";
var xmsgDOTT =    		"Dott.";
var xmsgDOTTSSA=    		"Dott.ssa";
var xmsgDR =    		"Dr.";
var xmsgDRA =    		"Dra.";
var xmsgDRS =    		"Drs.";
var xmsgENG =    		"Eng.";
var xmsgENGA =    		"Enga.";
var xmsgFR =    		"Fr.";
var xmsgFRAU =    		"Frau";
var xmsgGEN =    		"Gen.";
var xmsgGEOM =    		"Geom.";
var xmsgHERR =    		"Herr";
var xmsgHERRN =    		"Herrn";
var xmsgING =    		"Ing.";
var xmsgIR =    		"Ir.";
var xmsgLIC =    		"Lic.";
var xmsgLT =    		"Lt.";
var xmsgM =    			"M.";
var xmsgME =    		"Me.";
var xmsgMEVR =    		"Mevr.";
var xmsgMISS =    		"Miss";
var xmsgMLLE =    		"Mlle";
var xmsgMME =    		"Mme";
var xmsgMR =    		"Mr.";
var xmsgMRS =    		"Mrs.";
var xmsgMS =    		"Ms.";
var xmsgNR =    		"Nr.";
var xmsgOFFCR =    		"Officer";
var xmsgPAN =    		"Pan";
var xmsgPANI =    		"Pani";
var xmsgPE =    		"Pe.";
var xmsgPI=    			"Pi.";
var xmsgPM =    		"Pm.";
var xmsgPROF =    		"Prof.";
var xmsgPROFRE =    		"Prof.re";
var xmsgPROFSSA =    		"Prof.ssa";
var xmsgPROFA =    		"Profa.";
var xmsgSIG =    		"Sig.";
var xmsgSIGRA =    		"Sig.ra";
var xmsgSIR =    		"Sir";
var xmsgSR =    		"Sr.";
var xmsgSRA =		    	"Sra.";
var xmsgSRTA =    		"Srta.";

///////////////////////////////////////////////
// Button RESOURCES HERE:
///////////////////////////////////////////////
var xmsgBack=			"Prcdent";
var xmsgCancel=			"Annuler";
var xmsgExit=			"Quitter";
var xmsgFinish=			"Terminer";
var xmsgNext=			"Suivant";
var xmsgPrint=			"Imprimer";
var xmsgNo=				"Non";
var xmsgYes=			"Oui";
var xmsgRegister=		"Enregistrer";
var xmsgAuthorize=		"Autoriser";


///////////////////////////////////////////////
// Registration User Prompt RESOURCES HERE:
///////////////////////////////////////////////
var xmsgPleaseSelect=		"Veuillez slectionner ";
var xmsgPleaseSelect2=		"Slectionnez une option et cliquez sur Suivant";
var xmsgSelectCountry=		"Slectionnez le pays:";
var xmsgInformation=		"Informations";
var xmsgCompanyInfo=		"Informations sur la socit";
var xmsgContactInfo=		"Informations personnelles";
var xmsgSoftwareInfo=		"Informations sur les logiciels";
var xmsgConfirmInfo=		"Confirmation des informations";
var xmsgConfirmInfoTxt=		"Vrifiez que les informations ci-dessous sont correctes et cliquez sur Suivant.";
var xmsgCountryHdr=		"Enregistrement";
var xmsgCountryRegTo=		"Vous enregistrez ce produit pour:";
var xmsgCountryComp=		"Une socit";
var xmsgCountryIndiv=		"Un individu";
var xmsgCountryUpgrade=		"S'agit-il d'une mise  jour?";
var xmsgCountryUpgDetail=	"(Si vous enregistrez une mise  jour, vous devrez indiquer le numro de srie de votre ancien produit.)";
var xmsgConnectHdr=		"Connexion";
var xmsgConnectTxt=		"Si vous n'tes pas connect  l'Internet, veuillez vous connecter maintenant. Lorsque la connexion est tablie, cliquez sur Suivant.";
var xmsgTryAgain=		"Ressayer";
var xmsgReEnterOld=		"Veuillez ressaisir l'ancien numro de srie.";
var xmsgNewSernum3=		"Entrez le nouveau numro de srie et cliquez sur Suivant.";
var xmsgNewSernum4=		"Le numro de srie entr lors de l'installation de votre version d'valuation (000-00000000) ne peut pas etre enregistr. Si vous avez achet ce logiciel, vous avez du recevoir un nouveau numro de srie. Veuillez utiliser ce nouveau numro pour autoriser et activer le produit.";
var xmsgNewSernum5=		"Nouveau numro de srie*";
var xmsgNewSernum6=		"Confirmez le nouveau numro de srie*";
var xmsgNewSernum7=		"Le nouveau numro de srie que vous avez entr est incorrect. Slectionnez une option et cliquez sur Suivant";
var xmsgNewSernum8=		"Veuillez ressaisir le nouveau numro de srie.";
var xmsgUseOtherMethod=		"Utiliser une autre mthode d'enregistrement";
var xmsgContactAutodesk=	"Contacter Autodesk";
var xmsgContactOptions=		"Les options pour nous concater sont indiques ci-dessous.";

var xmsgPuchaseInfo1=		"Informations d'achat";
var xmsgPuchaseInfo2=		"Vous avez choisi d'acheter en ligne. Les crans suivants:";
var xmsgPuchaseInfo3=		"Recueillent les informations obligatoires";
var xmsgPuchaseInfo4=		"Ecrivent ces informations sur votre ordinateur pour les enregistrements futurs";
var xmsgPuchaseInfo5=		"Vous permettent de confirmer  chaque tape";
var xmsgPuchaseInfo6=		"Confirment l'achat et l'autorisation du logiciel";
var xmsgPuchaseInfo7=		"Cliquez sur Suivant pour continuer ou sur Annuler pour abandonner.";

var xmsgRegTitle=		"Enregistrer votre produit Autodesk";
var xmsgRegTitleBuy=		"Acheter des produits Autodesk en ligne";
var xmsgRegInfo=		"Informations d'enregistrement";
var xmsgRegInfo2=		"Mthode d'enregistrement";
var xmsgRegInfo3=		"Slectionnez une mthode d'enregistrement et cliquez sur Suivant.";
var xmsgRegmethod1=		"Connexion directe par Internet";
var xmsgRegmethod2=		"Demande par tlcopie";
var xmsgRegmethod3=		"Demande par e-mail";
var xmsgRegmethod4=		"Demande par courrier";
var xmsgRegmethod5=		"Enregistrement par courrier";
var xmsgRegmethod6=		"Cliquez sur Imprimer et envoyez ce formulaire :";
var xmsgRegmethod7=		"Enregistrement par tlcopie";
var xmsgRegmethod8=		"Cliquez sur Imprimer et faxez ce formulaire :";
var xmsgRegmethod9=		"Enregistrement par e-mail";
var xmsgRegmethod10=		"1) Slectionnez ce message dans son intgralit (Ctrl-A), copiez-le (Ctrl-C) et collez-le dans un message e-mail.";
var xmsgRegmethod11=		"2) Envoyez le message e-mail : ";
var xmsgRegmethod12=		"Si vous enregistrez votre produit par e-mail, vous recevrez une rponse d'Autodesk au plus tard dans 4 jours ouvrables Vous pouvez galement contacter Autodesk.";
var xmsgRegmethod13=		"Crer un message e-mail";
var xmsgRegAuthInfo=		"Enregistrement et autorisation";
var xmsgRegAuthInfo1=		"Autorisation";
var xmsgRegAuthInfo2=		"Enregistrement et autorisation (pour obtenir un code d'autorisation)";
var xmsgRegAuthInfo3=		"Entre d'un code d'autorisation reu au pralable"; 
var xmsgRegAuthInfo4=		"Code d'autorisation";
var xmsgRegAuthInfo5=		"Slectionnez votre pays, entrez le code d'autorisation et cliquez sur Suivant.";
var xmsgRegAuthInfo6=		"Confirmation de l'autorisation";	
var xmsgRegAuthInfo7=		"Merci d'avoir enregistr votre produit; il est dsormais autoris. Conservez le numro de srie et le code d'autorisation en un lieu sr. Cliquez sur Imprimer si vous souhaitez conserver une version papier de cette page.";
var xmsgRegAuthInfo8=		"Confirmation de l'enregistrement";		
var xmsgRegAuthInfo9=		"Merci d'avoir enregistr votre produit Autodesk. Ceci nous permettra d'tre encore plus proche de vous dans l'avenir.";
var xmsgRegAuthInfo10=		"Les informations relatives  l'enregistrement ont t sauvegardes dans ";		
var xmsgRegErrorHdr=		"Erreur d'enregistrement";
var xmsgRegErrorSystem=		"Une erreur systme temporarire s'est produite. Slectionnez une option et cliquez sur Suivant";
var xmsgRegErrorOnline=		"Impossible de terminer l'enregistrement en ligne Veuillez contacter Autodesk.";
var xmsgRegErrorPrevReg=	"Ce numro de srie est dj enregistr: impossible de terminer l'enregistrement en ligne. Veuillez contacter Autodesk.";
var xmsgRegErrorMaxAuth=	"Vous avez dpass le nombre maximal d'autorisations possible pour ce produit. Veuillez contacter Autodesk.";
var xmsgRegErrorInvalidOld=	"L'ancien numro de srie que vous avez entr est incorrect. Slectionnez une option et cliquez sur Suivant";
var xmsgRegErrorData=		"Erreur au niveau des informations d'enregistrement fournies Slectionnez une option et cliquez sur Suivant";
var xmsgRegErrorNetwork=	"Le produit que vous essayez d'enregistrer est une version rseau et doit etre install en tant que tel. Veuillez dsinstaller le logiciel et slectionner le type d'installation Rseau. Consultez la section traitant de l'installation rseau dans le Guide d'installation.";
var xmsgRegNoResponse=		"Achat en ligne impossible en raison d'un problme temporaire au niveau du systme. Slectionnez une option et cliquez sur Suivant";
var xmsgRegErrorAuthEntry=	"Le code d'autorisation que vous avez entr comporte une erreur. Slectionnez une option et cliquez sur Suivant";
var xmsgRegErrorAuth=		"Erreur au niveau du code d'autorisation Slectionnez une option et cliquez sur Suivant";
var xmsgRegConnError=		"Erreur de connexion";
var xmsgRegConnErrorTxt=	"Erreur au niveau de la connexion Internet Slectionnez une option et cliquez sur Suivant";
var xmsgRegPurchError1=		"Erreur d'achat";
var xmsgRegPurchError2=		"Cette transaction n'a pas pu tre conclue en ligne. Slectionnez une option et cliquez sur Suivant";
var xmsgRegPurchError3=		"Utilisez une autre mthode d'achat.";
var xmsgRegPurchError4=		"Achat en ligne impossible en raison d'un problme temporaire au niveau du systme Slectionnez une option et cliquez sur Suivant";
var xmsgRegPurchError5=		"Merci d'avoir choisi d'acqurir le logiciel Autodesk. Toutefois, l'achat en ligne n'est pas encore disponible.<p>Pour effectuer votre achat, veuillez choisir une des deux options suivantes :<br>(la slection d'une des options ci-dessous ouvrira une nouvelle fentre de navigateur)";

var xmsgPurchTransErrHdr=	"Erreur pendant la transaction d'achat";
var xmsgPurchTransError1=	"Un nouveau numro de srie est ncessaire pour terminer l'achat - aucun nouveau numro de srie n'a t fourni.<br>Veuillez contacter Autodesk.";
var xmsgPurchTransError2=	"Une erreur s'est produite pendant la confirmation du numro de srie sur nos serveurs.<br>Veuillez contacter Autodesk.";
var xmsgAuthErrHdr=			"Erreur d'autorisation";
var xmsgThankForPurchase=	"Merci d'avoir achet un logiciel Autodesk";
var xmsgAuthError1=			"L'autorisation est impossible en raison d'un problme temporaire. \
							Veuillez choisir une option et cliquer sur Suivant.";
var xmsgRentalInfo=			"Si vous avez obtenu ce produit en location, la priode de location commence ds l'autorisation.";
var xmsgRegLaterInfo=		"Pour enregistrer le produit maintenant, choisissez Enregistrer. Pour l'enregistrer plus tard, choisissez Aide|Acheter \
							 en ligne, puis choisissez Autoriser.";
var xmsgAuthorizeNow=		"Autoriser maintenant";
var xmsgAuthorizeLater=		"Autoriser plus tard";
var xmsgPurchOtherProdInfo=	"Pour acheter d'autres produits, dmarrez votre logiciel et choisissez Aide|Acheter en ligne.";
var xmsgPurchAdditionalProdInfo=	"Vous pouvez acheter d'autres logiciels  tout moment en choissant l'option\
									 Aide|Acheter en ligne.";
var xmsgRegAndAuthInfo=		"Votre logiciel a t enregistr et autoris";
var xmsgRegButNotAuthInfo=	"Votre logiciel a t enregistr mais non autoris.";
var xmsgRegisteredInfo=		"Votre logiciel a t enregistr.";
var xmsgNotRegOrAuthInfo=	"Votre logiciel n'a t ni enregistr ni autoris.";
var xmsgToAuthorizeInfo=	"Pour obtenir un code d'autorisation maintenant, choisissez Autoriser."
var xmsgRegAndActiveRentalInfo=	"Votre logiciel a t enregistr.La periode de location pour laquelle vous avez pay est dsormais active.";
var xmsgAuthNowOrLaterInfo=	"Pour obtenir un code d'autorisation plus tard, choisissez Aide|Acheter en ligne, puis Autoriser.";
var xmsgRemindRentalInfo=	"Vous recevrez des rappels vers la fin de la priode de location."
var xmsgPurchHdr=			"Confirmation de l'achat";
var xmsgRentalPurchHdr=		"Location";

var xmsgAuthResellerInfo=	"<a href=http://www.autodesk.com/supp/asc/northam/usa/usfindpd.htm target=_blank>Revendeur agr</a> (http://www.autodesk.com/supp/asc/northam/usa/usfindpd.htm)<br>\
							 Contactez votre revendeur agr pour terminer la procdure d'achat.";

/////////////////////////////////////////////
// Online Store Default URL HERE:
/////////////////////////////////////////////
var xmsgOnlineStoreDefaultURL=	"http://www.autodesk.com/estore/usa/index.htm";
var xmsgOnlineStoreURL=			"";
var xmsgOnlineStoreInfo=		"";

function SetOnlineStoreURLInfo() {
	xmsgOnlineStoreInfo=	"<a href=" + xmsgOnlineStoreURL + " target=_blank>Boutique en ligne</a> (" + xmsgOnlineStoreURL + ")<br>\
							 Achetez votre logiciel  la boutique en ligne d'Autodesk. Si vous n'y trouvez pas le \
							 produit qui vous intresse, veuillez contacter un revendeur agr.";
}

	//	Australia
var xmsgOnlineStoreURLAU=		"http://www.modusmedia-asia.com/autodeskau";
	//	Belgium
var xmsgOnlineStoreURLBE=		"http://estore.autodesk.com/dr/v2/ec_MAIN.Entry?SP=10007&amp;SID=25938&amp;CID=0&amp;CUR=56";
	//	Canada
var xmsgOnlineStoreURLCA=		"http://www.autodesk.com/estore/canada/index.htm";
	//	France
var xmsgOnlineStoreURLFR=		"http://estore.autodesk.com/v2.0-img/operations/autodkfr/desc/index.html";
	//	Germany
var xmsgOnlineStoreURLDE=		"http://estore.autodesk.com/v2.0-img/operations/autodkde/desc/";
	//	Hong Kong
var xmsgOnlineStoreURLHK=		"http://www.modusmedia-asia.com/autodeskhk";
	//	Ireland
var xmsgOnlineStoreURLIE=		"http://estore.autodesk.com/v2.0-img/operations/autodkir/desc/";
	//	Italy
var xmsgOnlineStoreURLIT=		"http://estore.autodesk.com/dr/v2/ec_MAIN.Entry?SP=10007&amp;SID=25831&amp;CID=0&amp;CUR=380";
	//	Japan
var xmsgOnlineStoreURLJP=		"http://www.modusmedia-asia.com/autodesk";
	//	Korea
var xmsgOnlineStoreURLKR=		"http://www.modusmedia-asia.com/autodesk";
	//	Netherlands
var xmsgOnlineStoreURLNL=		"http://www.digitalriver.com/v20/plsql/ec_MAIN.Entry?SP=10007&amp;SID=25937&amp;CID=0&amp;CUR=528";
	//	New Zealand
var	xmsgOnlineStoreURLNZ=		"http://www.modusmedia-asia.com/autodesknz";
	//	Singapore
var xmsgOnlineStoreURLSG=		"http://www.modusmedia-asia.com/autodesksg";
	//	Sweden
var xmsgOnlineStoreURLSE=		"http://estore.autodesk.com/dr/v2/ec_MAIN.Entry?SP=10007&amp;SID=25931&amp;CID=0&amp;CUR=752";
	//	Taiwan
var xmsgOnlineStoreURLTW=		"http://www.modusmedia-asia.com/autodesktw";
	//	UK
var xmsgOnlineStoreURLGB=		"http://estore.autodesk.com/v2.0-img/operations/autodkuk/desc/";

/////////////////////////////////////////////
// Single User Network RESOURCES HERE:
/////////////////////////////////////////////
var xmsgRegSunData1=		"Les donnes d'enregistrement ont t sauvegardes.";
var xmsgRegSunData2=		"Les donnes d'enregistrement requises pour le dploiement des clients ont t sauvegardes dans ";
var xmsgRegSunData3=		"L'ancien numro de srie que vous avez entr pour enregistrer cette mise  jour est incorrect. Veuillez contacter l'administrateur.";
var xmsgRegSunData4=		"le logiciel doit tre rinstall avec un ancien numro de srie correct.";
var xmsgRegSunData5=		"Installation rseau mono-utilisateur";
var xmsgRegSunData6=		"Pour terminer l'installation rseau mono-utilisateur, vous devez fournir des informations d'enregistrement. Les pages suivantes:";
var xmsgRegSunData7=		"Recueillent les informations requises.";
var xmsgRegSunData8=		"Permettent l'entre de l'ancien numro de srie si ncessaire pour une mise  jour.";
var xmsgRegSunData9=		"Enregistrent ces informations sur le serveur pour dploiement sur tous les clients.";
var xmsgRegSunData10=		"Ce logiciel sera enregistr sur la base des informations suivantes. Cliquez sur Suivant pour continuer.";

/////////////////////////////////////////////
// Voluntary RESOURCES HERE:
/////////////////////////////////////////////
var xmsgRegVol1=	"Enregistrement du produit";
var xmsgRegVol2=	"Slectionnez une option et cliquez sur Suivant:";
var xmsgRegVol3=	"Enregistrer maintenant - slectionnez cette option pour commencer l'enregistrement en ligne.";
var xmsgRegVol4=	"Enregistrer plus tard - slectionnez cette option pour utiliser le logiciel.";
var xmsgRegVol5=	"Ne plus afficher ce message";
var xmsgRegVol6=	"(Pour enregistrer votre produit plus tard, vous devrez choisir l'option correspondante dans la boite de dialogue Aide|A propos.)";

/////////////////////////////////////////////
// Japan RESOURCES HERE:
/////////////////////////////////////////////
var xmsgCustIDMainTitle=	"Identification du client";
var xmsgCustIDTitle1=		"ID client:";
var xmsgCustIDText2=		"Entrze votre ID client et votre numro de tlphone ci-dessous. Si vous n'avez pas d'ID client, laissez les deux zones vides Cliquez sur Suivant pour continuer.";
var xmsgCustIDTitle2=		"Numro de tlphone";
var xmsgCustIDTelEx4=		"(exemple: 03-111-1234)";
var xmsgRegCustIDTel=		"L'ID client et le numro de tlphone que vous avez entrs ne correspondent pas. Slectionnez une option et cliquez sur Suivant";
var xmsgPhoneNoAst=		"Tlphone:";
var xmsgKatakana=		"Nom de socit (Katakana):*";
var xmsgKatakana2=		"Nom de socit (Katakana):";
var xmsgDepartment=		"Service:*";
var xmsgDepartment2=		"Service:";

/////////////////////////////////////////////
// Autodesk Contact RESOURCES HERE:
/////////////////////////////////////////////
var xmsgFormWebHdr=	"Web";
var xmsgFormWebData=	"https://register.autodesk.com";
var xmsgFormWebData2=	"*(Vous pouvez obtenir un code d'autorisation auprs de votre revendeur ou  l'adresse \
			<a href=https://register.autodesk.com target='_blank'>https://register.autodesk.com</a>)";
var xmsgFormEmailHdr=	"E-mail";
var xmsgFormEmailData=	"";
var xmsgFormFaxHdr=		"Tlcopie";
var xmsgFormFaxHdrLocal=	"Tlcopie  la filiale la plus proche";
var xmsgFormFaxHdrReg=	"Enregistrement par tlcopie";
var xmsgFormFaxData=	"";
var xmsgFormFaxDataRegister=	"";
var xmsgFormCallHdr=	"Tlphone";
var xmsgFormCallData=	"";
var xmsgFormMailHdr=	"Courrier";
var xmsgFormMailHdrLocal=	"Courrier  la filiale la plus proche";
var xmsgFormMailHdrReg=	"Enregistrement par courrier";
var xmsgFormMailData=	"";
var xmsgFormMailDataRegister=   "";
var xmsgFormPurchHdr=	"Acheter le logiciel";
var xmsgFormPurchData=	"http://www.autodesk.com/purchase/usa/index.htm";

var xmsgFormEmailDataUS=	"authcodes@autodesk.com";
var xmsgFormFaxDataUS=	"800-225-6490 or 415-507-4690";
var xmsgFormCallDataUS=	"415-507-4690 or 800-551-1490";			 
var xmsgFormMailDataUS=	"Product Registrations<br>Autodesk Inc<br>111 McInnis Parkway<br>San Rafael, CA 94903";

var xmsgFormEmailDataEMA=	"authcodes.neu@autodesk.com";
var xmsgFormFaxDataEMA=		"+41-32-723-9169";
var xmsgFormMailDataEMA=	"Autodesk Development S. r.l.<br>Puits-Godet 6<br>Case postale 35<br>CH-2005 Neuchtel<br>Suisse";

var xmsgFormEmailDataAPC=	"ap.register@autodesk.com";
var xmsgFormFaxDataAPC=		"65-4700-728";
var xmsgFormMailDataAPC=	"Autodesk Asia Pte. Ltd.<br>Alexandra Post Office<br>P.O. Box 225<br>Singapore 911508";

/////////////////////////////////////////////
// Privacy Statement RESOURCES HERE:
/////////////////////////////////////////////

var xmsgPrivacy=        "Les informations que vous fournissez seront utilises par Autodesk pour gnrer votre code d'autorisation,\
                        pour vous tenir inform sur nos produits et services et pour assurer qu'en tant qu'utilisateur enregistr,\
                        vous bnficiez des offres rserves aux utilisateurs Autodesk autoriss. Ces informations ne seront ni\
                        vendues  des tiers, ni communiques  qui que ce soit en dehors d'Autodesk et de nos partenaires\
                        agrs.<br><br> \
			Si vous voulez corriger ou mettre  jour les informations vous concernant :\
			Si vous vous trouvez aux Etats-Unis, au Canada ou en Amrique latine,\
			veuillez complter le formulaire de changement d'adresse ('Change of Address Page') <a href=http://autodeskgs.custhelp.com/cgi-bin/autodeskgs/faq target='_blank'> \
			http://autodeskgs.custhelp.com/cgi-bin/autodeskgs/faq</a>.\
			Si vous vous trouvez en Europe, au Moyen-Orient ou en Afrique, contactez-nous par e-mail  <a href='mailto:authcodes.neu@autodesk.com'>\
			authcodes.neu@autodesk.com</a>, ou par tlcopie au +41-32-723-9169.\
			Si vous vous trouvez dans la rgion Asie-Pacifique, contactez-nous par e-mail  <a href='mailto:ap.register@autodesk.com'> \
			ap.register@autodesk.com</a> ou  <a href='mailto:japan.register@autodesk.com'> \
			japan.register@autodesk.com</a> (Japon uniquement), ou par tlcopie au +65-4700728.\
			";


/////////////////////////////////////////////

//=======================================================================
// Header Insert Blocks
//=======================================================================

// Set Registration Info Header
var InsertRegInfo =     ' <br><p><b>'+xmsgRegInfo+'</b></p>\
			  <p>Les champs affichs en <font color="red"> rouge</font>\
  			  et marqus d\'un astrisque &nbsp(<font color="red">*</font>)&nbsp\
			  sont obligatoires pour le traitement de votre enregistrement. Remplissez le\
                          formulaire et cliquez sur Suivant.</p>';

// Set Confirm Info Header
var InsertConfirmInfo = ' <br><p><b>'+xmsgConfirmInfo+'</b></p>\
			  <p>'+xmsgConfirmInfoTxt+'</p>';

// Set the Software Info Header
var InsertSoftwareBar = ' <b>'+xmsgSoftwareInfo+'</b>';

// Set the Primary Application Usage Header
var InsertAppUsageBar = '<b>'+xmsgAppUsageQ1+'</b><br>\
			 <font color="red">'+xmsgAppUsageQ2+'</font>';

//=======================================================================
// Serial Number & License Insert Blocks
//=======================================================================

// Set Product Confirm Field <CONFIRM>
var ProductConfirm = ' <tr>\
			  <td>'+xmsgProduct+'&nbsp;</td>\
			  <td valign="top" align="left"><font color="#848284">'+product+'</font></td>\
			</tr>';

// Set Serial Number Field <CONFIRM>
var sernumConfirm = ' <tr>\
			  <td>'+xmsgsernum+'&nbsp;</td>\
			  <td valign="top" align="left"><font color="#848284">'+sernum+'</font></td>\
			</tr>';

// Set Request Code <CONFIRM>
if (reqtype == "2") {
	var RC = '	<tr>\
				  <td>'+xmsgApplicationKey+'&nbsp;</td>\
				  <td valign="top" align="left"><font color="#848284">'+req+'</font></td>\
				</tr>';
} else {
	var RC = '	<tr>\
				  <td>'+xmsgRequestCode+'&nbsp;</td>\
				  <td valign="top" align="left"><font color="#848284">'+req+'</font></td>\
				</tr>';
}

// Set Authcode <CONFIRM>
var authConfirm = '<tr><td>'+xmsgRegAuthCode+'</td>\
					   <td valign="top" align="left"><font color="#848284">'+auth+'</font></td>\
				   </tr>';

// Set Old Serial Number <ENTER>
var UpgradeSerialBlock = '<p><font color="red">'+xmsgOldSerialNum+'</font><br>\
			  <input type="text" name="osernum" size="12" maxlength="12">&nbsp;(xxx-xxxxxxxx)</p>';

// Set Old Serial Number <ENTER - Red>
var UpgradeSerialBlockBlack = '<p><font color="red">'+xmsgOldSerialNum+'<font><br>\
			  <input type="text" name="osernum" size="12" maxlength="12">&nbsp;(xxx-xxxxxxxx)</p>';

// Set Old Serial Number Field <CONFIRM - Red>
var OSN = ' <tr>\
			  <td><font color="red">'+xmsgOldSerialNum+'&nbsp;</font></td>\
			  <td><font color="#848284">'+osernum+'</font></td>\
			</tr>';

// Set Old Serial Number Field <CONFIRM - Grey>
var OSNGrey = ' <tr>\
			  <td>'+xmsgOsernum+'&nbsp;</td>\
			  <td><font color="#848284">'+osernum+'</font></td>\
			</tr>';

// New Serial Number <ENTER>
var NewSerialBlock = '<p><font color="red">'+xmsgNewSernum5+'</font><br>\
			  <input type="text" name="nsernum" size="12" maxlength="12">&nbsp;(xxx-xxxxxxxx)</p>';

// New Serial Number <RE-ENTER>
var NewSerialBlock2 = '<p><font color="red">'+xmsgNewSernum6+'</font><br>\
			  <input type="text" name="nsernumconfirm" size="12" maxlength="12">&nbsp;(xxx-xxxxxxxx)</p>';

//=======================================================================
// Salutation Insert Blocks
//=======================================================================

var SalutationUS = '      <select name="sal" size="1">\
                          <option selected value="select">'+xmsgPleaseSelect+'</option>\
				<option value="ADM">'+xmsgADM +'</option>\
				<option value="CAPT">'+xmsgCAPT +'</option>\
				<option value="DR">'+xmsgDR +'</option>\
				<option value="DRA">'+xmsgDRA +'</option>\
				<option value="GEN">'+xmsgGEN +'</option>\
				<option value="ING">'+xmsgING +'</option>\
				<option value="LIC">'+xmsgLIC +'</option>\
				<option value="LT">'+xmsgLT +'</option>\
				<option value="M">'+xmsgM +'</option>\
				<option value="MISS">'+xmsgMISS +'</option>\
				<option value="MLLE">'+xmsgMLLE +'</option>\
				<option value="MME">'+xmsgMME +'</option>\
				<option value="MR">'+xmsgMR +'</option>\
				<option value="MRS">'+xmsgMRS +'</option>\
				<option value="MS">'+xmsgMS +'</option>\
				<option value="NR">'+xmsgNR+'</option>\
				<option value="OFFCR">'+xmsgOFFCR +'</option>\
				<option value="PROF">'+xmsgPROF +'</option>\
				<option value="SIR">'+xmsgSIR +'</option>\
				<option value="SR">'+xmsgSR +'</option>\
				<option value="SRA">'+xmsgSRA +'</option>\
				<option value="SRTA">'+xmsgSRTA+'</option>\
                        </select>';

var SalutationAPC = '      <select name="sal" size="1">\
                          <option selected value="select">'+xmsgPleaseSelect+'</option>\
				<option value="ADM">'+xmsgADM +'</option>\
				<option value="CAPT">'+xmsgCAPT +'</option>\
				<option value="COL">'+xmsgCOL +'</option>\
				<option value="COMM">'+xmsgCOMM +'</option>\
				<option value="DR">'+xmsgDR +'</option>\
				<option value="GEN">'+xmsgGEN +'</option>\
				<option value="ING">'+xmsgING +'</option>\
				<option value="LIC">'+xmsgLIC +'</option>\
				<option value="LT">'+xmsgLT +'</option>\
				<option value="MISS">'+xmsgMISS +'</option>\
				<option value="MR">'+xmsgMR +'</option>\
				<option value="MRS">'+xmsgMRS +'</option>\
				<option value="MS">'+xmsgMS +'</option>\
				<option value="NR">'+xmsgNR +'</option>\
				<option value="PROF">'+xmsgPROF +'</option>\
				<option value="SIR">'+xmsgSIR +'</option>\
				<option value="SR">'+xmsgSR +'</option>\
				<option value="SRA">'+xmsgSRA +'</option>\
				<option value="SRTA">'+xmsgSRTA +'</option>\
                        </select>';

var SalutationEMA = '      <select name="sal" size="1">\
                          <option selected value="select">'+xmsgPleaseSelect+'</option>\
				<option value="ARCH">'+xmsgARCH +'</option>\
				<option value="ARQ">'+xmsgARQ +'</option>\
				<option value="ARQA">'+xmsgARQA +'</option>\
				<option value="AVV">'+xmsgAVV +'</option>\
				<option value="CA">'+xmsgCA +'</option>\
				<option value="DHR">'+xmsgDHR +'</option>\
				<option value="DOTT">'+xmsgDOTT +'</option>\
				<option value="DOTT.SSA">'+xmsgDOTTSSA+'</option>\
				<option value="DR">'+xmsgDR +'</option>\
				<option value="DRA">'+xmsgDRA +'</option>\
				<option value="DRS">'+xmsgDRS +'</option>\
				<option value="ENG">'+xmsgENG +'</option>\
				<option value="ENGA">'+xmsgENGA +'</option>\
				<option value="FR">'+xmsgFR +'</option>\
				<option value="FRAU">'+xmsgFRAU +'</option>\
				<option value="GEOM">'+xmsgGEOM +'</option>\
				<option value="HERR">'+xmsgHERR +'</option>\
				<option value="HERRN">'+xmsgHERRN +'</option>\
				<option value="ING">'+xmsgING +'</option>\
				<option value="IR">'+xmsgIR +'</option>\
				<option value="LIC">'+xmsgLIC +'</option>\
				<option value="M">'+xmsgM +'</option>\
				<option value="ME">'+xmsgME +'</option>\
				<option value="MEVR">'+xmsgMEVR +'</option>\
				<option value="MISS">'+xmsgMISS +'</option>\
				<option value="MLLE">'+xmsgMLLE +'</option>\
				<option value="MME">'+xmsgMME +'</option>\
				<option value="MR">'+xmsgMR +'</option>\
				<option value="MRS">'+xmsgMRS +'</option>\
				<option value="MS">'+xmsgMS +'</option>\
				<option value="PAN">'+xmsgPAN +'</option>\
				<option value="PANI">'+xmsgPANI +'</option>\
				<option value="PE">'+xmsgPE +'</option>\
				<option value="PI">'+xmsgPI+'</option>\
				<option value="PM">'+xmsgPM +'</option>\
				<option value="PROF">'+xmsgPROF +'</option>\
				<option value="PROF.RE">'+xmsgPROFRE +'</option>\
				<option value="PROF.SSA">'+xmsgPROFSSA +'</option>\
				<option value="PROFA">'+xmsgPROFA +'</option>\
				<option value="SIG">'+xmsgSIG +'</option>\
				<option value="SIG.RA">'+xmsgSIGRA +'</option>\
				<option value="SIR">'+xmsgSIR +'</option>\
				<option value="SR">'+xmsgSR +'</option>\
				<option value="SRA">'+xmsgSRA +'</option>\
				<option value="SRTA">'+xmsgSRTA+'</option>\
                        </select>';


//=======================================================================
// Rolodex Insert Blocks
//=======================================================================

// Set the Company Name <ENTER> Text Block. Contains [Company Text, Company Field]
var InsertCompanyBlock = ' <b>'+xmsgCompanyInfo+'</b><br>\
						   <br><font color="red">'+xmsgCompanyName+'<br>\
						     <input type="text" name="comp" size="62" maxlength="40"></font>';

// Set the Contact Name <ENTER> Text Block [Salutation, First Name, Last Name]
var InsertNameBlock = ' <p><font color="red">'+xmsgFirstname+'<br>\
			   <input type="text" name="fname" size="62" maxlength="40"></font></p>\
			<p><font color="red">'+xmsgLastname+'<br>\
			   <input type="text" name="lname" size="62" maxlength="40"></font></p>';

//=======================================================================
// Register Info Insert Blocks
//=======================================================================

var RegInfoConfirm = xmsgRegAuthInfo10 + '<a href="' + reginfofolder + '" target="_blank">' + reginfofolder + '</a>';

//=======================================================================
// State, Region, and Province Information
//=======================================================================

// Set State Region Province field
var SRP =   xmsgSRP+'<br><font color="#848284">'+state+'</font><br>';

// Country State/Province Info
var ATStPrRegHTML = ' <br><select name="state" size="1">\
						<option value="select">'+xmsgPleaseSelect+'</option>\
						<option value="B">Burgenland </option>\
						<option value="K">Krnten </option>\
						<option value="N">Niedersterreich </option>\
						<option value="O">Obersterreich </option>\
						<option value="S">Salzburg </option>\
						<option value="ST">Steiermark </option>\
						<option value="T">Tirol </option>\
						<option value="V">Vorarlberg </option>\
						<option value="W">Wien </option>\
						</select>';

var AUStPrRegHTML = '	<br><select name="state" size="1">\
						<option value="select">'+xmsgPleaseSelect+'</option>\
						<option value="ACT">Aust Capital Terr </option>\
						<option value="NSW">New South Wales </option>\
						<option value="NT">Northern Territory </option>\
						<option value="QLD">Queensland </option>\
						<option value="SA">South Australia </option>\
						<option value="TAS">Tasmania </option>\
						<option value="VIC">Victoria </option>\
						<option value="WA">Western Australia </option>\
						</select>';

var USStPrRegHTML = '	<br><select name="state" size="1">\
						<option value="select">'+xmsgPleaseSelect+'</option>\
						<option value="AL">Alabama </option>\
						<option value="AK">Alaska </option>\
						<option value="AZ">Arizona </option>\
						<option value="AR">Arkansas </option>\
						<option value="CA">California </option>\
						<option value="CO">Colorado </option>\
						<option value="CT">Connecticut </option>\
						<option value="DE">Delaware </option>\
						<option value="DC">District of Columbia </option>\
						<option value="FL">Florida </option>\
						<option value="GA">Georgia </option>\
						<option value="HI">Hawaii </option>\
						<option value="ID">Idaho </option>\
						<option value="IL">Illinois </option>\
						<option value="IN">Indiana </option>\
						<option value="IA">Iowa </option>\
						<option value="KS">Kansas </option>\
						<option value="KY">Kentucky </option>\
						<option value="LA">Louisiana </option>\
						<option value="ME">Maine </option>\
						<option value="MD">Maryland </option>\
						<option value="MA">Massachusetts </option>\
						<option value="MI">Michigan </option>\
						<option value="MN">Minnesota </option>\
						<option value="MS">Mississippi </option>\
						<option value="MO">Missouri </option>\
						<option value="MT">Montana </option>\
						<option value="NE">Nebraska </option>\
						<option value="NV">Nevada </option>\
						<option value="NH">New Hampshire </option>\
						<option value="NJ">New Jersey </option>\
						<option value="NM">New Mexico </option>\
						<option value="NY">New York </option>\
						<option value="NC">North Carolina </option>\
						<option value="ND">North Dakota </option>\
						<option value="OH">Ohio </option>\
						<option value="OK">Oklahoma </option>\
						<option value="OR">Oregon </option>\
						<option value="PA">Pennsylvania </option>\
						<option value="RI">Rhode Island </option>\
						<option value="SC">South Carolina </option>\
						<option value="SD">South Dakota </option>\
						<option value="TN">Tennessee </option>\
						<option value="TX">Texas </option>\
						<option value="UT">Utah </option>\
						<option value="VT">Vermont </option>\
						<option value="VA">Virginia </option>\
						<option value="VI">Virgin Islands</option>\
						<option value="WA">Washington </option>\
						<option value="WV">West Virginia </option>\
						<option value="WI">Wisconsin </option>\
						<option value="WY">Wyoming </option>\
						<option value="AA">APOAmerica</option>\
						<option value="AE">APOEurope</option>\
						<option value="AP">APOPacific</option>\
						</select>';

var CAStPrRegHTML = '	<br><select name="state" size="1">\
						<option value="select">'+xmsgPleaseSelect+'</option>\
						<option value="AB">Alberta </option>\
						<option value="BC">British Columbia </option>\
						<option value="MB">Manitoba </option>\
						<option value="NB">New Brunswick </option>\
						<option value="NF">Newfoundland </option>\
						<option value="NT">Northwest Territories </option>\
						<option value="NS">Nova Scotia </option>\
						<option value="NU">Nunavut </option>\
						<option value="ON">Ontario </option>\
						<option value="PE">Prince Edward Island </option>\
						<option value="QC">Quebec </option>\
						<option value="SK">Saskatchewan </option>\
						<option value="YT">Yukon </option>\
						<option value="ZZ">Outside province </option>\
						</select>';

var CHStPrRegHTML = ' <br><select name="state" size="1">\
						<option value="select">'+xmsgPleaseSelect+'</option>\
						<option value="AG">Aargau </option>\
						<option value="AI">Appenzell Innerrhoden </option>\
						<option value="AR">Appenzell Ausserrhoden </option>\
						<option value="BE">Bern </option>\
						<option value="BL">Basel-Landschaft </option>\
						<option value="BS">Basel-Stadt </option>\
						<option value="FR">Fribourg </option>\
						<option value="GE">Genve </option>\
						<option value="GL">Glarus </option>\
						<option value="GR">Graubenden </option>\
						<option value="JU">Jura </option>\
						<option value="LU">Luzern </option>\
						<option value="NE">Neuchtel </option>\
						<option value="NW">Nidwalden </option>\
						<option value="OW">Obwalden </option>\
						<option value="SG">St.Gallen </option>\
						<option value="SH">Schaffhausen </option>\
						<option value="SO">Solothurn </option>\
						<option value="SZ">Schwyz </option>\
						<option value="TG">Thurgau </option>\
						<option value="TI">Ticino </option>\
						<option value="UR">Uri </option>\
						<option value="VD">Vaud </option>\
						<option value="VS">Valais </option>\
						<option value="ZG">Zug </option>\
						<option value="ZH">Zrich </option>\
						</select>';

var CNStPrRegHTML = ' <br><select name="state" size="1">\
						<option value="select">'+xmsgPleaseSelect+'</option>\
						<option value="110">Anhui </option>\
						<option value="010">Beijing </option>\
						<option value="150">Fujian </option>\
						<option value="260">Gansu </option>\
						<option value="190">Guangdong </option>\
						<option value="210">Guangxi </option>\
						<option value="220">Guizhou </option>\
						<option value="200">Hainan </option>\
						<option value="060">Hebei </option>\
						<option value="090">Heilongjiang </option>\
						<option value="180">Henan </option>\
						<option value="170">Hubei </option>\
						<option value="160">Hunan </option>\
						<option value="100">Jiangsu </option>\
						<option value="140">Jiangxi </option>\
						<option value="080">Jilin </option>\
						<option value="070">Liaoning </option>\
						<option value="040">NeiMongol </option>\
						<option value="270">Ningxia </option>\
						<option value="280">Qinghai </option>\
						<option value="250">Shaanxi </option>\
						<option value="120">Shandong </option>\
						<option value="020">Shanghai </option>\
						<option value="050">Shanxi </option>\
						<option value="230">Sichuan </option>\
						<option value="030">Tianjin </option>\
						<option value="290">Xinjiang </option>\
						<option value="300">Xizang </option>\
						<option value="240">Yunnan </option>\
						<option value="130">Zhejiang </option>\
						</select>';

var DEStPrRegHTML = ' <br><select name="state" size="1">\
						<option value="select">'+xmsgPleaseSelect+'</option>\
						<option value="08">Baden-Wrttemberg </option>\
						<option value="09">Bayern </option>\
						<option value="11">Berlin </option>\
						<option value="12">Brandenburg </option>\
						<option value="04">Bremen </option>\
						<option value="02">Hamburg </option>\
						<option value="06">Hessen </option>\
						<option value="13">Mecklenburg-Vorpommern </option>\
						<option value="03">Niedersachsen </option>\
						<option value="05">Nordrhein-Westfalen </option>\
						<option value="07">Rheinland-Pfalz </option>\
						<option value="10">Saarland </option>\
						<option value="14">Sachsen </option>\
						<option value="15">Sachsen-Anhalt</option>\
						<option value="01">Schleswig-Holstein </option>\
						<option value="16">Thringen </option>\
						</select>';

var ESStPrRegHTML = ' <br><select name="state" size="1">\
						<option value="select">'+xmsgPleaseSelect+'</option>\
						<option value="01">lava </option>\
						<option value="02">Albacete </option>\
						<option value="03">Alicante </option>\
						<option value="04">Almera </option>\
						<option value="33">Asturias </option>\
						<option value="05">vila </option>\
						<option value="06">Badajoz </option>\
						<option value="07">Baleares </option>\
						<option value="08">Barcelona </option>\
						<option value="09">Burgos </option>\
						<option value="10">Cceres </option>\
						<option value="11">Cdiz </option>\
						<option value="39">Cantabria </option>\
						<option value="12">Castelln </option>\
						<option value="13">CiudadReal </option>\
						<option value="14">Crdoba </option>\
						<option value="16">Cuenca </option>\
						<option value="17">Gerona </option>\
						<option value="18">Granada </option>\
						<option value="19">Guadalajara </option>\
						<option value="20">Guipzcoa </option>\
						<option value="21">Huelva </option>\
						<option value="22">Huesca </option>\
						<option value="23">Jan </option>\
						<option value="15">LaCorua </option>\
						<option value="26">LaRioja </option>\
						<option value="35">LasPalmas </option>\
						<option value="24">Len </option>\
						<option value="25">Lrida </option>\
						<option value="27">Lugo </option>\
						<option value="28">Madrid </option>\
						<option value="29">Mlaga </option>\
						<option value="30">Murcia </option>\
						<option value="31">Navarra </option>\
						<option value="32">Orense </option>\
						<option value="34">Palencia </option>\
						<option value="36">Pontevedra </option>\
						<option value="37">Salamanca </option>\
						<option value="38">Santa Cruz de Tenerife </option>\
						<option value="40">Segovia </option>\
						<option value="41">Sevilla </option>\
						<option value="42">Soria </option>\
						<option value="43">Tarragona </option>\
						<option value="44">Teruel </option>\
						<option value="45">Toledo </option>\
						<option value="46">Valencia </option>\
						<option value="47">Valladolid </option>\
						<option value="48">Vizcaya </option>\
						<option value="49">Zamora </option>\
						<option value="50">Zaragoza </option>\
						</select>';

var HKStPrRegHTML = ' <br><select name="state" size="1">\
						<option value="select">'+xmsgPleaseSelect+'</option>\
						<option value="HK">Hong Kong Island </option>\
						<option value="KLN">Kowloon </option>\
						<option value="NT">New Territories </option>\
						</select>';

var IEStPrRegHTML = ' <br><select name="state" size="1">\
						<option value="select">'+xmsgPleaseSelect+'</option>\
						<option value="CK">Cork </option>\
						<option value="CL">Clare </option>\
						<option value="CW">Carlow </option>\
						<option value="DB">Dublin </option>\
						<option value="DG">Donegal </option>\
						<option value="GW">Galway </option>\
						<option value="KD">Kildare </option>\
						<option value="KK">Kilkenny </option>\
						<option value="KV">Cavan </option>\
						<option value="KY">Kerry </option>\
						<option value="LF">Longford </option>\
						<option value="LI">Limerick </option>\
						<option value="LM">Leitrim </option>\
						<option value="LS">Laois </option>\
						<option value="LT">Louth </option>\
						<option value="MH">Monaghan </option>\
						<option value="MT">Meath </option>\
						<option value="MY">Mayo </option>\
						<option value="OS">Offaly </option>\
						<option value="RC">Rosscommon </option>\
						<option value="SG">Sligo </option>\
						<option value="TP">Tipperary </option>\
						<option value="WF">Waterford </option>\
						<option value="WK">Wicklow </option>\
						<option value="WM">Westmeath </option>\
						<option value="WX">Wexford </option>\
						</select>';

var ITStPrRegHTML = ' <br><select name="state" size="1">\
						<option value="select">'+xmsgPleaseSelect+'</option>\
						<option value="AG">Agrigento </option>\
						<option value="AL">Alessandria </option>\
						<option value="AN">Ancona </option>\
						<option value="AO">Aosta </option>\
						<option value="AR">Arezzo </option>\
						<option value="AP">Ascoli Piceno </option>\
						<option value="AT">Asti </option>\
						<option value="AV">Avellino </option>\
						<option value="BA">Bari </option>\
						<option value="BL">Belluno </option>\
						<option value="BN">Benevento </option>\
						<option value="BG">Bergamo </option>\
						<option value="BI">Biella </option>\
						<option value="BO">Bologna </option>\
						<option value="BZ">Bolzano </option>\
						<option value="BS">Brescia </option>\
						<option value="BR">Brindisi </option>\
						<option value="CA">Cagliari </option>\
						<option value="CL">Caltanissetta </option>\
						<option value="CB">Campobasso </option>\
						<option value="CE">Caserta </option>\
						<option value="CT">Catania </option>\
						<option value="CZ">Catanzaro </option>\
						<option value="CH">Chieti </option>\
						<option value="CO">Como </option>\
						<option value="CS">Cosenza </option>\
						<option value="CR">Cremona </option>\
						<option value="KR">Crotone </option>\
						<option value="CN">Cuneo </option>\
						<option value="EN">Enna </option>\
						<option value="FE">Ferrara </option>\
						<option value="FI">Firenze </option>\
						<option value="FG">Foggia </option>\
						<option value="FO">Forl </option>\
						<option value="FR">Frosinone </option>\
						<option value="GE">Genova </option>\
						<option value="GO">Gorizia </option>\
						<option value="GR">Grosseto </option>\
						<option value="IM">Imperia </option>\
						<option value="IS">Isernia </option>\
						<option value="AQ">L`Aquila </option>\
						<option value="SP">LaSpezia </option>\
						<option value="LT">Latina </option>\
						<option value="LE">Lecce </option>\
						<option value="LC">Lecco </option>\
						<option value="LI">Livorno </option>\
						<option value="LO">Lodi </option>\
						<option value="LU">Lucca </option>\
						<option value="MC">Macerata </option>\
						<option value="MN">Mantova </option>\
						<option value="MS">Massa Carrara </option>\
						<option value="MT">Matera </option>\
						<option value="ME">Messina </option>\
						<option value="MI">Milano </option>\
						<option value="MO">Modena </option>\
						<option value="NA">Napoli </option>\
						<option value="NO">Novara </option>\
						<option value="NU">Nuoro </option>\
						<option value="OR">Oristano </option>\
						<option value="PD">Padova </option>\
						<option value="PA">Palermo </option>\
						<option value="PR">Parma </option>\
						<option value="PV">Pavia </option>\
						<option value="PG">Perugia </option>\
						<option value="PS">Pesaro e Urbino </option>\
						<option value="PE">Pescara </option>\
						<option value="PC">Piacenza </option>\
						<option value="PI">Pisa </option>\
						<option value="PT">Pistoia </option>\
						<option value="PN">Pordenone </option>\
						<option value="PZ">Potenza </option>\
						<option value="PO">Prato </option>\
						<option value="RG">Ragusa </option>\
						<option value="RA">Ravenna </option>\
						<option value="RC">Reggio Calabria </option>\
						<option value="RE">Reggio Emilia </option>\
						<option value="RI">Rieti </option>\
						<option value="RN">Rimini </option>\
						<option value="RM">Roma </option>\
						<option value="RO">Rovigo </option>\
						<option value="SA">Salerno </option>\
						<option value="SS">Sassari </option>\
						<option value="SV">Savona </option>\
						<option value="SI">Siena </option>\
						<option value="SR">Siracusa </option>\
						<option value="SO">Sondrio </option>\
						<option value="TA">Taranto </option>\
						<option value="TE">Teramo </option>\
						<option value="TR">Terni </option>\
						<option value="TP">Trapani </option>\
						<option value="TN">Trento </option>\
						<option value="TV">Treviso </option>\
						<option value="TS">Trieste </option>\
						<option value="TO">Torino </option>\
						<option value="UD">Udine </option>\
						<option value="VA">Varese </option>\
						<option value="VE">Venice </option>\
						<option value="VB">Verbano-Cusio-Ossola </option>\
						<option value="VC">Vercelli </option>\
						<option value="VR">Verona </option>\
						<option value="VV">Vibo Valentia </option>\
						<option value="VI">Vicenza </option>\
						<option value="VT">Viterbo </option>\
						</select>';


var JPStPrRegHTML = ' <br><select name="state" size="1">\
						<option value="select">'+xmsgPleaseSelect+'</option>\
						<option value="23">Aichi-ken </option>\
						<option value="05">Akita-ken </option>\
						<option value="02">Aomori-ken </option>\
						<option value="12">Chiba-ken </option>\
						<option value="38">Ehime-ken </option>\
						<option value="18">Fukui-ken </option>\
						<option value="40">Fukuoka-ken </option>\
						<option value="07">Fukushima-ken </option>\
						<option value="21">Gifu-ken </option>\
						<option value="10">Gunma-ken </option>\
						<option value="34">Hiroshima-ken </option>\
						<option value="01">Hokkaido </option>\
						<option value="28">Hyogo-ken </option>\
						<option value="08">Ibaragi-ken </option>\
						<option value="17">Ishikawa-ken </option>\
						<option value="03">Iwate-ken </option>\
						<option value="37">Kagawa-ken </option>\
						<option value="46">Kagoshima-ken </option>\
						<option value="14">Kanagawa-ken </option>\
						<option value="39">Kochi-ken </option>\
						<option value="43">Kumamoto-ken </option>\
						<option value="26">Kyoto-fu </option>\
						<option value="24">Mie-ken </option>\
						<option value="04">Miyagi-ken </option>\
						<option value="45">Miyazaki-ken </option>\
						<option value="42">Nagasaki-ken </option>\
						<option value="20">Nagano-ken </option>\
						<option value="29">Nara-ken </option>\
						<option value="15">Niigata-ken </option>\
						<option value="44">Oita-ken </option>\
						<option value="33">Okayama-ken </option>\
						<option value="47">Okinawa-ken </option>\
						<option value="27">Osaka-fu </option>\
						<option value="41">Saga-ken </option>\
						<option value="11">Saitama-ken </option>\
						<option value="25">Shiga-ken </option>\
						<option value="32">Shimane-ken </option>\
						<option value="22">Shizuoka-ken </option>\
						<option value="09">Tochigi-ken </option>\
						<option value="36">Tokushima-ken </option>\
						<option value="13">Tokyo-to </option>\
						<option value="31">Tottori-ken </option>\
						<option value="16">Toyama-ken </option>\
						<option value="30">Wakayama-ken </option>\
						<option value="06">Yamagata-ken </option>\
						<option value="35">Yamaguchi-ken </option>\
						<option value="19">Yamanashi-ken </option>\
						</select>';

var MXStPrRegHTML = ' <br><select name="state" size="1">\
						<option value="select">'+xmsgPleaseSelect+'</option>\
						<option value="AGS">Aguascalientes </option>\
						<option value="BCN">Baja CaliforniaN </option>\
						<option value="BCS">Baja CaliforniaS </option>\
						<option value="CMP">Campeche </option>\
						<option value="CHS">Chiapas </option>\
						<option value="CHI">Chihuahua </option>\
						<option value="COA">Coahuila </option>\
						<option value="COL">Colima </option>\
						<option value="DF">DistritoFederal </option>\
						<option value="DGO">Durango </option>\
						<option value="MEX">Estado de Mxico </option>\
						<option value="GTO">Guanajuato </option>\
						<option value="GRO">Guerrero </option>\
						<option value="HGO">Hidalgo </option>\
						<option value="JAL">Jalisco </option>\
						<option value="MCH">Michoacn </option>\
						<option value="MOR">Morelos </option>\
						<option value="NL">NuevoLon </option>\
						<option value="OAX">Oaxaca </option>\
						<option value="PUE">Puebla </option>\
						<option value="QRO">Quertaro </option>\
						<option value="QR">QuintanaRoo </option>\
						<option value="SLP">San Luis Potos </option>\
						<option value="SIN">Sinaloa </option>\
						<option value="SON">Sonora </option>\
						<option value="TAB">Tabasco </option>\
						<option value="TMS">Tamaulipas </option>\
						<option value="TLX">Tlaxcala </option>\
						<option value="VER">Veracruz </option>\
						<option value="YUC">Yucatn </option>\
						<option value="ZAC">Zacatecas </option>\
						</select>';

var MYStPrRegHTML = ' <br><select name="state" size="1">\
						<option value="select">'+xmsgPleaseSelect+'</option>\
						<option value="JOH">Johor </option>\
						<option value="KED">Kedah </option>\
						<option value="KEL">Kelantan </option>\
						<option value="KUL">KualaLumpur </option>\
						<option value="LAB">Labuan </option>\
						<option value="MEL">Melaka </option>\
						<option value="PAH">Pahang </option>\
						<option value="PEL">Perlis </option>\
						<option value="PER">Perak </option>\
						<option value="PIN">PulauPinang </option>\
						<option value="SAB">Sabah </option>\
						<option value="SAR">Sarawak </option>\
						<option value="SEL">Selangor </option>\
						<option value="SER">NegeriSembilan </option>\
						<option value="TRE">Terengganu </option>\
						</select>';

var PTStPrRegHTML = ' <br><select name="state" size="1">\
						<option value="select">'+xmsgPleaseSelect+'</option>\
						<option value="40">Alentejo </option>\
						<option value="50">Algarve </option>\
						<option value="24">Beira Interior </option>\
						<option value="15">Beira Litoral </option>\
						<option value="10">Entre Douro e Minho </option>\
						<option value="22">Estremadura e Ribatejo </option>\
						<option value="31">Lisboa e Setbal </option>\
						<option value="70">Reg. Aut. da Madeira </option>\
						<option value="60">Reg. Aut. dos Aores </option>\
						<option value="16">Trs-os-Montes e Alto Douro </option>\
						</select>';

var TWStPrRegHTML = ' <br><select name="state" size="1">\
						<option value="select">'+xmsgPleaseSelect+'</option>\
						<option value="KSH">Kaoshung City </option>\
						<option value="TPE">Taipei City </option>\
						<option value="TWN">Taiwan Prov. </option>\
						</select>';


// Set the State Confirmation Field (Long Name)
var SRP =   xmsgSRP+'<br><font color="#848284">'+state+'</font><br>';

//=======================================================================
// Zip and Postal Code Information
//=======================================================================

var ZipHTML= ' <p>'+xmsgZipCode+'<br>\
			   <input type="text" name="zip" size="10" maxlength="10">\
			   </p>';

//Zip confirmation
var ZipHTMLConfirm= ' <p>'+xmsgZipCode+'<br>\
			   <font color="#848284">'+zip+'</font>\
			   </p>';

var PostHTML= ' <p>'+xmsgPostCode+'<br>\
				<input type="text" name="zip" size="10" maxlength="10">\
				</p>';

// Postal Confirmation
var PostHTMLConfirm= ' <p>'+xmsgPostCode+'<br>\
			   <font color="#848284">'+zip+'</font>\
  			   </p>';

var CanPostHTML= ' <p>'+xmsgPostCode+'<br>\
				   <input type="text" name="zip" size="3" maxlength="3">-\
				   <input type="text" name="zip" size="3" maxlength="3">\
				   </p>';

//=======================================================================
// Country Long Name Information
//=======================================================================

var CountryHTML= xmsgSelectCountry+'<br>\
				<select name="country" size="1">\
				<option selected value="select">'+xmsgPleaseSelect+'</option>\
				<option value="DZ">Algrie </option>\
				<option value="BE">Belgique </option>\
				<option value="BJ">Bnin </option>\
				<option value="CM">Cameroun </option>\
				<option value="CA">Canada </option>\
				<option value="FR">France </option>\
				<option value="GF">Guyane </option>\
				<option value="HT">Hati </option>\
				<option value="LU">Luxembourg </option>\
				<option value="MA">Maroc </option>\
				<option value="MU">Maurice </option>\
				<option value="MC">Monaco </option>\
				<option value="NC">Nouvelle-Caldonie </option>\
				<option value="PF">Polynsie franaise </option>\
				<option value="RE">Runion </option>\
				<option value="SN">Sngal </option>\
				<option value="CH">Suisse </option>\
				<option value="TF">Terres australes et antarctiques franaises </option>\
				<option value="TN">Tunisie </option>\
				<option value="AL">Albania </option>\
				<option value="DZ">Algeria </option>\
				<option value="AS">American Samoa </option>\
				<option value="AD">Andorra </option>\
				<option value="AO">Angola </option>\
				<option value="AI">Anguilla </option>\
				<option value="AQ">Antarctica </option>\
				<option value="AG">Antigua and Barbuda </option>\
				<option value="AR">Argentina </option>\
				<option value="AM">Armenia </option>\
				<option value="AW">Aruba </option>\
				<option value="AU">Australia </option>\
				<option value="AT">Austria </option>\
				<option value="AZ">Azerbaijan </option>\
				<option value="BS">Bahamas </option>\
				<option value="BH">Bahrain </option>\
				<option value="BD">Bangladesh </option>\
				<option value="BB">Barbados </option>\
				<option value="BY">Belarus </option>\
				<option value="BE">Belgium </option>\
				<option value="BZ">Belize </option>\
				<option value="BJ">Benin </option>\
				<option value="BM">Bermuda </option>\
				<option value="BT">Bhutan </option>\
				<option value="BO">Bolivia </option>\
				<option value="BA">Bosnia and Herzegovina </option>\
				<option value="BW">Botswana </option>\
				<option value="BV">Bouvet Island </option>\
				<option value="BR">Brazil </option>\
				<option value="IO">British Indian Ocean Territory </option>\
				<option value="BN">Brunei Darussalam </option>\
				<option value="BG">Bulgaria </option>\
				<option value="BF">Burkina Faso </option>\
				<option value="BI">Burundi </option>\
				<option value="KH">Cambodia </option>\
				<option value="CM">Cameroon </option>\
				<option value="CA">Canada </option>\
				<option value="CV">Cape Verde </option>\
				<option value="KY">Cayman Islands </option>\
				<option value="CF">Central African Republic </option>\
				<option value="TD">Chad </option>\
				<option value="CL">Chile </option>\
				<option value="CN">China </option>\
				<option value="CX">Christmas Island (Australia) </option>\
				<option value="CC">Cocos (Keeling) Islands </option>\
				<option value="CO">Colombia </option>\
				<option value="KM">Comoros </option>\
				<option value="CG">Congo </option>\
				<option value="CK">Cook Islands (New Zealand) </option>\
				<option value="CR">Costa Rica </option>\
				<option value="CI">Cote d`Ivoire </option>\
				<option value="HR">Croatia (Hrvatska) </option>\
				<option value="CY">Cyprus </option>\
				<option value="CZ">Czech Republic </option>\
				<option value="CD">Democratic Republic of the Congo </option>\
				<option value="DK">Denmark </option>\
				<option value="DJ">Djibouti </option>\
				<option value="DM">Dominica </option>\
				<option value="DO">Dominican Republic </option>\
				<option value="TP">East Timor </option>\
				<option value="EC">Ecuador </option>\
				<option value="EG">Egypt </option>\
				<option value="SV">El Salvador </option>\
				<option value="GQ">Equatorial Guinea </option>\
				<option value="ER">Eritrea </option>\
				<option value="EE">Estonia </option>\
				<option value="ET">Ethiopia </option>\
				<option value="FK">Falkland Islands </option>\
				<option value="FO">Faroe Islands </option>\
				<option value="FJ">Fiji </option>\
				<option value="FI">Finland </option>\
				<option value="FR">France </option>\
				<option value="GF">French Guiana </option>\
				<option value="PF">French Polynesia </option>\
				<option value="TF">French Southern Territories </option>\
				<option value="GA">Gabon </option>\
				<option value="GM">Gambia </option>\
				<option value="GE">Georgia </option>\
				<option value="DE">Germany </option>\
				<option value="GH">Ghana </option>\
				<option value="GI">Gibraltar </option>\
				<option value="GR">Greece </option>\
				<option value="GL">Greenland </option>\
				<option value="GD">Grenada </option>\
				<option value="GP">Guadeloupe </option>\
				<option value="GU">Guam </option>\
				<option value="GT">Guatemala </option>\
				<option value="GN">Guinea </option>\
				<option value="GW">Guinea-Bissau </option>\
				<option value="GY">Guyana </option>\
				<option value="HT">Haiti </option>\
				<option value="HM">Heard and Mcdonald Islands </option>\
				<option value="HN">Honduras </option>\
				<option value="HK">Hong Kong </option>\
				<option value="HU">Hungary </option>\
				<option value="IS">Iceland </option>\
				<option value="IN">India </option>\
				<option value="ID">Indonesia </option>\
				<option value="IE">Ireland </option>\
				<option value="IL">Israel </option>\
				<option value="IT">Italy </option>\
				<option value="JM">Jamaica </option>\
				<option value="JP">Japan </option>\
				<option value="JO">Jordan </option>\
				<option value="KZ">Kazakhstan </option>\
				<option value="KE">Kenya </option>\
				<option value="KI">Kiribati </option>\
				<option value="KR">Korea, South </option>\
				<option value="KW">Kuwait </option>\
				<option value="KG">Kyrgyzstan </option>\
				<option value="LA">Laos, People`s Democratic Republic </option>\
				<option value="LV">Latvia </option>\
				<option value="LB">Lebanon </option>\
				<option value="LS">Lesotho </option>\
				<option value="LR">Liberia </option>\
				<option value="LI">Liechtenstein </option>\
				<option value="LT">Lithuania </option>\
				<option value="LU">Luxembourg </option>\
				<option value="MO">Macau </option>\
				<option value="MK">Macedonia </option>\
				<option value="MG">Madagascar </option>\
				<option value="MW">Malawi </option>\
				<option value="MY">Malaysia </option>\
				<option value="MV">Maldives </option>\
				<option value="ML">Mali </option>\
				<option value="MT">Malta </option>\
				<option value="MH">Marshall Islands </option>\
				<option value="MQ">Martinique </option>\
				<option value="MR">Mauritania </option>\
				<option value="MU">Mauritius </option>\
				<option value="YT">Mayotte </option>\
				<option value="MX">Mexico </option>\
				<option value="FM">Micronesia </option>\
				<option value="MD">Moldova </option>\
				<option value="MC">Monaco </option>\
				<option value="MN">Mongolia </option>\
				<option value="MS">Montserrat </option>\
				<option value="MA">Morocco </option>\
				<option value="MZ">Mozambique </option>\
				<option value="MM">Myanmar </option>\
				<option value="NA">Namibia </option>\
				<option value="NR">Nauru </option>\
				<option value="NP">Nepal </option>\
				<option value="NL">Netherlands </option>\
				<option value="AN">Netherlands Antilles </option>\
				<option value="NC">New Caledonia </option>\
				<option value="NZ">New Zealand </option>\
				<option value="NI">Nicaragua </option>\
				<option value="NE">Niger </option>\
				<option value="NG">Nigeria </option>\
				<option value="NU">Niue </option>\
				<option value="NF">Norfolk Island </option>\
				<option value="MP">Northern Mariana Islands </option>\
				<option value="NO">Norway </option>\
				<option value="OM">Oman </option>\
				<option value="PK">Pakistan </option>\
				<option value="PW">Palau </option>\
				<option value="PS">Palestinian Territory </option>\
				<option value="PA">Panama </option>\
				<option value="PG">Papua New Guinea </option>\
				<option value="PY">Paraguay </option>\
				<option value="PE">Peru </option>\
				<option value="PH">Philippines </option>\
				<option value="PN">Pitcairn </option>\
				<option value="PL">Poland </option>\
				<option value="PT">Portugal </option>\
				<option value="PR">Puerto Rico </option>\
				<option value="QA">Qatar </option>\
				<option value="RE">Reunion </option>\
				<option value="RO">Romania </option>\
				<option value="RU">Russian Federation </option>\
				<option value="RW">Rwanda </option>\
				<option value="KN">Saint Kitts and Nevis </option>\
				<option value="LC">Saint Lucia </option>\
				<option value="VC">Saint Vincent Islands </option>\
				<option value="WS">Samoa </option>\
				<option value="SM">San Marino </option>\
				<option value="ST">Sao Tome and Principe </option>\
				<option value="SA">Saudi Arabia </option>\
				<option value="SN">Senegal </option>\
				<option value="SC">Seychelles </option>\
				<option value="SL">Sierra Leone </option>\
				<option value="SG">Singapore </option>\
				<option value="SK">Slovak Republic </option>\
				<option value="SI">Slovenia </option>\
				<option value="GS">S.Georgia and S.Sandwich Is. </option>\
				<option value="SB">Solomon Islands </option>\
				<option value="SO">Somalia </option>\
				<option value="ZA">South Africa </option>\
				<option value="ES">Spain </option>\
				<option value="LK">Sri Lanka </option>\
				<option value="SH">St Helena </option>\
				<option value="PM">St Pierre and Miquelon </option>\
				<option value="SR">Suriname </option>\
				<option value="SJ">Svalbard and Jan Mayen Islands </option>\
				<option value="SZ">Swaziland </option>\
				<option value="SE">Sweden </option>\
				<option value="CH">Switzerland </option>\
				<option value="SY">Syria </option>\
				<option value="TW">Taiwan </option>\
				<option value="TJ">Tajikistan </option>\
				<option value="TZ">Tanzania, United Republic of </option>\
				<option value="TH">Thailand </option>\
				<option value="TG">Togo </option>\
				<option value="TK">Tokelau </option>\
				<option value="TO">Tonga </option>\
				<option value="TT">Trinidad and Tobago </option>\
				<option value="TN">Tunisia </option>\
				<option value="TR">Turkey </option>\
				<option value="TM">Turkmenistan </option>\
				<option value="TC">Turks and Caicos Islands </option>\
				<option value="TV">Tuvalu </option>\
				<option value="UG">Uganda </option>\
				<option value="UA">Ukraine </option>\
				<option value="AE">United Arab Emirates </option>\
				<option value="GB">United Kingdom </option>\
				<option value="US">United States </option>\
				<option value="UY">Uruguay </option>\
				<option value="UM">US Minor Outlying Islands </option>\
				<option value="UZ">Uzbekistan </option>\
				<option value="VU">Vanuatu </option>\
				<option value="VA">Vatican City State </option>\
				<option value="VE">Venezuela </option>\
				<option value="VN">Vietnam </option>\
				<option value="VG">Virgin Islands (British) </option>\
				<option value="VI">Virgin Islands (US) </option>\
				<option value="WF">Wallis and Futuna Islands </option>\
				<option value="EH">Western Sahara </option>\
				<option value="YE">Yemen </option>\
				<option value="ZM">Zambia </option>\
				<option value="ZW">Zimbabwe </option>\
				</select>';

//=======================================================================
// Application Usage Information
//=======================================================================
var AppUsageHTML = '\
					<select multiple name="appusage" size="4">\
					<option value="1">Architecture </option>\
					<option value="2">Services immobiliers </option>\
					<option value="3">Gnie civil </option>\
					<option value="4">Jeux </option>\
					<option value="5">Systmes d\'informations gographiques </option>\
					<option value="6">Mcanique </option>\
					<option value="7">Edition vido </option>\
					<option value="8">Autres </option>\
					</select>';


//=======================================================================
// Geo Specfic Information
//=======================================================================

// Here are the variables that we are using in the pages
// The Switch statements populate them with the correct values
// as initialized previously
//
var InsertStPrRegSelect="";			// Select statement with all country options for state/province/region
var InsertStPrRegText=xmsgRegText;		// State, Province or Region text variable.  All but US&CAN use Region
var InsertZipPostText=PostHTML;			// Zip Code or Postal code?  All but US&CAN use Postal; US&CAN Set in switch
var InsertZipPostTextConfirm=PostHTMLConfirm;	// Confirmed Zip or Postal code.
var Geo="";					// Geo variable set based on country
var SalutationBlock="";

function SetCountryParms() {

	//	set the default online store url
xmsgOnlineStoreURL = xmsgOnlineStoreDefaultURL;

// Assign Geo, contact information, and salutations
switch (country) {
  case "AT": InsertStPrRegSelect=ATStPrRegHTML; //Austria zip 10
			 xmsgFormEmailData=xmsgFormEmailDataEMA;
			 xmsgFormFaxData=xmsgFormFaxDataEMA;
			 xmsgFormMailData="Autodesk GmbH<br>Traungasse 16<br>A-4600 Wels";
			 xmsgFormMailDataRegister=xmsgFormMailDataEMA;
			 Geo="EMA";
			 SalutationBlock=SalutationEMA;
			 break;
  case "AU": InsertStPrRegSelect=AUStPrRegHTML; //Australia zip 10
			 xmsgFormEmailData=xmsgFormEmailDataAPC;
			 xmsgFormFaxData="1-800-331453 or 0011-800-4700-7280";
			 xmsgFormFaxDataRegister=xmsgFormFaxDataAPC;
			 xmsgFormMailData=xmsgFormMailDataAPC;
			 xmsgOnlineStoreURL=xmsgOnlineStoreURLAU;
			 Geo="APC";
			 SalutationBlock=SalutationAPC;
			 break;
  case "BR": 					//Brazil zip 10
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataUS;
			 xmsgFormFaxData=xmsgFormFaxDataUS;
			 xmsgFormCallData="000-811-994-5571";
			 xmsgFormMailData=xmsgFormMailDataUS;
			 Geo="LAM";
			 SalutationBlock=SalutationUS;
			 break;
  case "CH": InsertStPrRegSelect=CHStPrRegHTML; //Switzerland zip 10
			 xmsgFormEmailData=xmsgFormEmailDataEMA;
			 xmsgFormFaxData=xmsgFormFaxDataEMA;
			 xmsgFormMailData="Autodesk AG<br>Zurlindenstrasse 29<br>CH-4133<br>Pratteln</p>";
			 xmsgFormMailDataRegister=xmsgFormMailDataEMA;
			 Geo="EMA";
			 SalutationBlock=SalutationEMA;
			 break;
  case "CL": 					//Chile zip 10
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataUS;
			 xmsgFormFaxData=xmsgFormFaxDataUS;
			 xmsgFormCallData="1230-020-2001";
			 xmsgFormMailData=xmsgFormMailDataUS;
			 Geo="LAM";
			 SalutationBlock=SalutationUS;
			 break;
  case "CN": InsertStPrRegSelect=CNStPrRegHTML; //China zip 10
			 xmsgFormEmailData=xmsgFormEmailDataAPC;
			 xmsgFormFaxData="86-10-6505-6858";
			 xmsgFormFaxDataRegister=xmsgFormFaxDataAPC;
			 xmsgFormMailData=xmsgFormMailDataAPC;
			 Geo="APC";
			 SalutationBlock=SalutationAPC;
			 break;
  case "CO": 					//Colombia zip 10
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataUS;
			 xmsgFormFaxData=xmsgFormFaxDataUS;
			 xmsgFormCallData="980-12-1311";
			 xmsgFormMailData=xmsgFormMailDataUS;
			 Geo="LAM";
			 SalutationBlock=SalutationUS;
			 break;
  case "CY": 					//Cyprus Republic zip 10
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataEMA;
			 xmsgFormFaxData=xmsgFormFaxDataEMA;
			 xmsgFormMailData="PO Box 3283<br>Nicosia";
			 xmsgFormMailDataRegister=xmsgFormMailDataEMA;
			 Geo="EMA";
			 SalutationBlock=SalutationEMA;
			 break;
  case "CZ": 					//Czech Republic zip 10
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataEMA;
			 xmsgFormFaxData=xmsgFormFaxDataEMA;
			 xmsgFormMailData="Autodesk s.r.o<br>Jeseniova 1<br>CZ-13000 Prague 3";
			 xmsgFormMailDataRegister=xmsgFormMailDataEMA;
			 Geo="EMA";
			 SalutationBlock=SalutationEMA;
			 break;
  case "DE": InsertStPrRegSelect=DEStPrRegHTML; //Germany zip 10
			 xmsgFormEmailData=xmsgFormEmailDataEMA;
			 xmsgFormFaxData=xmsgFormFaxDataEMA;
			 xmsgFormMailData="Autodesk GmbH<br>Hansastrasse 28<br>D-80686 Mnchen";
			 xmsgFormMailDataRegister=xmsgFormMailDataEMA;
			 Geo="EMA";
			 SalutationBlock=SalutationEMA;
			 xmsgOnlineStoreURL=xmsgOnlineStoreURLDE;
			 break;
  case "DK":									//Denmark zip 10
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataEMA;
			 xmsgFormFaxData=xmsgFormFaxDataEMA;
			 xmsgFormMailData=xmsgFormMailDataEMA;
			 Geo="EMA";
			 SalutationBlock=SalutationEMA;
			 break;
  case "ES": InsertStPrRegSelect=ESStPrRegHTML; //Spain zip 10
			 xmsgFormEmailData=xmsgFormEmailDataEMA;
			 xmsgFormFaxData=xmsgFormFaxDataEMA;
			 xmsgFormMailData="Autodesk S.A.<br>C/Constitucion 1, Planta 4<br>08960 Sant Just, Barcelona";
			 xmsgFormMailDataRegister=xmsgFormMailDataEMA;
			 Geo="EMA";
			 SalutationBlock=SalutationEMA;
			 break;
  case "FI":									//Finland zip 10
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataEMA;
			 xmsgFormFaxData=xmsgFormFaxDataEMA;
			 xmsgFormMailData=xmsgFormMailDataEMA;
			 Geo="EMA";
			 SalutationBlock=SalutationEMA;
			 break;
  case "FR":					//France zip 10
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataEMA;
			 xmsgFormFaxData=xmsgFormFaxDataEMA;
			 xmsgFormMailData="Autodesk S.A.<br>Btiment les Ellipses<br>5, avenue du Chemin de Presles<br>94410 - Saint-Maurice";
			 xmsgFormMailDataRegister=xmsgFormMailDataEMA;
			 Geo="EMA";
			 SalutationBlock=SalutationEMA;
			 xmsgOnlineStoreURL=xmsgOnlineStoreURLFR;
			 break;
  case "GB":					//United Kingdom zip 10
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataEMA;
			 xmsgFormFaxData=xmsgFormFaxDataEMA;
			 xmsgFormMailData="Autodesk Ltd<br>Cross Lanes<br>Guildford, Surrey<br>GU1 1UJ";
			 xmsgFormMailDataRegister=xmsgFormMailDataEMA;
			 Geo="EMA";
			 SalutationBlock=SalutationEMA;
			 xmsgOnlineStoreURL=xmsgOnlineStoreURLGB;
			 break;
  case "GR": 					//Greece zip 10
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataEMA;
			 xmsgFormFaxData=xmsgFormFaxDataEMA;
			 xmsgFormMailData="PO Box 75059, Z.C.<br>17610 Kalithea/Athens";
			 xmsgFormMailDataRegister=xmsgFormMailDataEMA;
			 Geo="EMA";
			 SalutationBlock=SalutationEMA;
			 break;
  case "GU": StateProvInvo="";			//Guam
			 InsertStPrRegText="";
			 InsertZipPostText=ZipHTML;
			 InsertZipPostTextConfirm=ZipHTMLConfirm;
			 xmsgFormEmailData=xmsgFormEmailDataUS;
			 xmsgFormFaxData=xmsgFormFaxDataUS;
			 xmsgFormCallData=xmsgFormCallDataUS;
			 xmsgFormMailData=xmsgFormMailDataUS;
			 Geo="US";
			 SalutationBlock=SalutationUS;
			 break;
  case "HK": InsertStPrRegSelect=HKStPrRegHTML; //Hong Kong zip 10
			 xmsgFormEmailData=xmsgFormEmailDataAPC;
			 xmsgFormFaxData="852-2-824-3228";
			 xmsgFormFaxDataRegister=xmsgFormFaxDataAPC;
			 xmsgFormMailData=xmsgFormMailDataAPC;
			 Geo="APC";
			 SalutationBlock=SalutationAPC;
			 xmsgOnlineStoreURL=xmsgOnlineStoreURLHK;
			 break;
  case "HU": 					//Hungary zip 10
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataEMA;
			 xmsgFormFaxData=xmsgFormFaxDataEMA;
			 xmsgFormMailData="Autodesk Ltd.<br>Arpad Center<br>H-1134, Budapest, Arboc.U.6<br>Hungary";
			 xmsgFormMailDataRegister=xmsgFormMailDataEMA;
			 Geo="EMA";
			 SalutationBlock=SalutationEMA;
			 break;
 case "IN": 					//India zip 10
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataAPC;
			 xmsgFormFaxData="91 80 2072131";			 
			 xmsgFormFaxDataRegister=xmsgFormFaxDataAPC;
			 xmsgFormMailData=xmsgFormMailDataAPC;
			 Geo="APC";
			 SalutationBlock=SalutationAPC;
			 break;
  case "IE": InsertStPrRegSelect=IEStPrRegHTML; //Ireland zip 10
			 xmsgFormEmailData=xmsgFormEmailDataEMA;
			 xmsgFormFaxData=xmsgFormFaxDataEMA;
			 xmsgFormMailData=xmsgFormMailDataEMA;
			 Geo="EMA";
			 SalutationBlock=SalutationEMA;
			 xmsgOnlineStoreURL=xmsgOnlineStoreURLIE;
			 break;
  case "IL": 					//Israel zip 10
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataEMA;
			 xmsgFormFaxData=xmsgFormFaxDataEMA;
			 xmsgFormMailData="Autodesk<br>12 Ha'hilazon street<br>Ramat Gan<br>52522";
			 xmsgFormMailDataRegister=xmsgFormMailDataEMA;
			 Geo="EMA";
			 SalutationBlock=SalutationEMA;
			 break;
  case "IT": InsertStPrRegSelect=ITStPrRegHTML; //Italy zip 10
			 xmsgFormEmailData=xmsgFormEmailDataEMA;
			 xmsgFormFaxData=xmsgFormFaxDataEMA;
			 xmsgFormMailData="Autodesk S.p.A.<br>Milanofiori,<br>Strada 4 Palazzo A5<br>20090 Assago MI";
			 xmsgFormMailDataRegister=xmsgFormMailDataEMA;
			 Geo="EMA";
			 SalutationBlock=SalutationEMA;
			 xmsgOnlineStoreURL=xmsgOnlineStoreURLIT;
			 break;
  case "JM": 					//Jamaica zip 10
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataUS;
			 xmsgFormFaxData=xmsgFormFaxDataUS;
		 	 xmsgFormCallData="0800-551-1490";
		 	 xmsgFormMailData=xmsgFormMailDataUS;
			 Geo="LAM";
			 SalutationBlock=SalutationUS;
			 break;
  case "JP": InsertStPrRegSelect=JPStPrRegHTML; //Japan zip 10
			 xmsgFormEmailData="japan.register@autodesk.com";
			 xmsgFormFaxData="81-03-3473-9512";
			 xmsgFormFaxDataRegister=xmsgFormFaxDataAPC;
			 xmsgFormCallData="03-3473-9529";			 
			 xmsgFormMailData=xmsgFormMailDataAPC;
			 Geo="APC";
			 SalutationBlock=SalutationAPC;
			 xmsgOnlineStoreURL=xmsgOnlineStoreURLJP;
			 break;
  case "KR": 					//Korea, South zip 10
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataAPC;
			 xmsgFormFaxData="82-2-527-8716";
			 xmsgFormFaxDataRegister=xmsgFormFaxDataAPC;
			 xmsgFormMailData=xmsgFormMailDataAPC;
		 	 Geo="APC";
			 SalutationBlock=SalutationAPC;
			 xmsgOnlineStoreURL=xmsgOnlineStoreURLKR;
			 break;
  case "MX": InsertStPrRegSelect=MXStPrRegHTML; //Mexico zip 10
			 xmsgFormEmailData=xmsgFormEmailDataUS;
			 xmsgFormFaxData=xmsgFormFaxDataUS;
			 xmsgFormCallData="95-800-551-1490";
			 xmsgFormMailData=xmsgFormMailDataUS;
			 Geo="LAM";
			 SalutationBlock=SalutationUS;
			 break;
  case "MY": InsertStPrRegSelect=MYStPrRegHTML; //Malaysia zip 10
			 xmsgFormEmailData=xmsgFormEmailDataAPC;
			 xmsgFormFaxData=xmsgFormFaxDataAPC;
			 xmsgFormMailData=xmsgFormMailDataAPC;
			 Geo="APC";
			 SalutationBlock=SalutationAPC;
			 break;
  case "NL": 					//Netherlands zip 10
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataEMA;
			 xmsgFormFaxData=xmsgFormFaxDataEMA;
			 xmsgFormMailData="Autodesk B.V.<br>Postbus 8651<br>NL-3009 AR Rotterdam";
			 xmsgFormMailDataRegister=xmsgFormMailDataEMA;
			 Geo="EMA";
			 SalutationBlock=SalutationEMA;
			 xmsgOnlineStoreURL=xmsgOnlineStoreURLNL;
			 break;
  case "NO":					//Norway zip 10
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataEMA;
			 xmsgFormFaxData=xmsgFormFaxDataEMA;
			 xmsgFormMailData=xmsgFormMailDataEMA;
			 Geo="EMA";
			 SalutationBlock=SalutationEMA;
			 break;
  case "NZ": 
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataAPC;
			 xmsgFormFaxData="00-800-4700-7280";
			 xmsgFormFaxDataRegister=xmsgFormFaxDataAPC;
			 xmsgFormMailData=xmsgFormMailDataAPC;
			 Geo="APC";
			 SalutationBlock=SalutationAPC;
			 xmsgOnlineStoreURL=xmsgOnlineStoreURLNZ;
			 break;
  case "PL": 					//Poland zip 10
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataEMA;
			 xmsgFormFaxData="00-800-4700-7280";
			 xmsgFormFaxDataRegister=xmsgFormFaxDataEMA;
			 xmsgFormMailData="Autodesk GmbH Oddzial<br>w Warszawie<br>ul. W. Rzymowskiego 34<br>02-697 Warszawa";
			 xmsgFormMailDataRegister=xmsgFormMailDataEMA;
			 Geo="EMA";
			 SalutationBlock=SalutationEMA;
			 break;
  case "PT": InsertStPrRegSelect=PTStPrRegHTML; //Portugal zip 10
			 xmsgFormEmailData=xmsgFormEmailDataEMA;
			 xmsgFormFaxData=xmsgFormFaxDataEMA;
			 xmsgFormMailData="Autodesk Software Limited<br>Apartado 152<br>2670 Loures";
			 xmsgFormMailDataRegister=xmsgFormMailDataEMA;
			 Geo="EMA";
			 SalutationBlock=SalutationEMA;
			 break;
  case "RU": 					//Russian Federation zip 10
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataEMA;
			 xmsgFormFaxData=xmsgFormFaxDataEMA;
			 xmsgFormMailData=xmsgFormMailDataEMA;
			 Geo="EMA";
			 SalutationBlock=SalutationEMA;
			 break;
  case "SE":							//Sweden zip 10
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataEMA;
			 xmsgFormFaxData=xmsgFormFaxDataEMA;
			 xmsgFormMailData="Autodesk AB<br>Mlndalsvgen 24<br>Box 14261<br>S-400 20 Gteborg";
			 xmsgFormMailDataRegister=xmsgFormMailDataEMA;
			 Geo="EMA";
			 SalutationBlock=SalutationEMA;
			 xmsgOnlineStoreURL=xmsgOnlineStoreURLSE;
			 break;
  case "SG": 
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataAPC;
			 xmsgFormFaxData=xmsgFormFaxDataAPC;
			 xmsgFormMailData=xmsgFormMailDataAPC;
			 Geo="APC";
			 SalutationBlock=SalutationAPC;
			 xmsgOnlineStoreURL=xmsgOnlineStoreURLSG;
			 break;
  case "TH": 
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataAPC;
			 xmsgFormFaxData=xmsgFormFaxDataAPC;
			 xmsgFormMailData=xmsgFormMailDataAPC;
			 Geo="APC";
			 SalutationBlock=SalutationAPC;
			 break;
  case "TW": InsertStPrRegSelect=TWStPrRegHTML; //Taiwan zip 10
			 xmsgFormEmailData=xmsgFormEmailDataAPC;
			 xmsgFormFaxData="886-2546-1223";
			 xmsgFormFaxDataRegister=xmsgFormFaxDataAPC;
			 xmsgFormMailData=xmsgFormMailDataAPC;
			 Geo="APC";
			 SalutationBlock=SalutationAPC;
			 xmsgOnlineStoreURL=xmsgOnlineStoreURLTW;
			 break;
  case "US": InsertStPrRegSelect=USStPrRegHTML; //United States zip 5-4
			 InsertStPrRegText=xmsgStText;
			 InsertZipPostText=ZipHTML;
			 InsertZipPostTextConfirm=ZipHTMLConfirm;
			 xmsgFormEmailData=xmsgFormEmailDataUS;
			 xmsgFormFaxData=xmsgFormFaxDataUS;
			 xmsgFormCallData=xmsgFormCallDataUS;
			 xmsgFormMailData=xmsgFormMailDataUS;
			 Geo="US";
			 SalutationBlock=SalutationUS;
			 break;
  case "ZA": 					//South Africa zip 10				
			 InsertStPrRegSelect=""; 
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataEMA;
			 xmsgFormFaxData=xmsgFormFaxDataEMA;
			 xmsgFormMailData=' (thin envelopes)<br>Autodesk Ltd.<br>PO Box 7398<br>\
                                            Centurion 0046<p>(parcels)<br>Autodesk Ltd.<br>Grand Floor<br>\
	                                    International<br>Business Gateway<br>New Road, Midrand</p>';
			 xmsgFormMailDataRegister=xmsgFormMailDataEMA;
			 Geo="EMA";
			 SalutationBlock=SalutationEMA;
			 break;


  case "CA": //Canada zip 3-3
			 xmsgOnlineStoreURL=xmsgOnlineStoreURLCA;
  case "PM": //St Pierre and Miquelon
			 InsertStPrRegSelect=CAStPrRegHTML;
			 InsertStPrRegText=xmsgPrText;
			 InsertZipPostText=PostHTML;	//Use CanPostHTML with ereg.dll support in future
			 xmsgFormEmailData=xmsgFormEmailDataUS;
			 xmsgFormFaxData=xmsgFormFaxDataUS;
			 xmsgFormCallData=xmsgFormCallDataUS;
			 xmsgFormMailData=xmsgFormMailDataUS;
			 Geo="CAN";
			 SalutationBlock=SalutationUS;
			 break;


  case "AS": //American Samoa
  case "AQ": //Antarctica
  case "BD": //Bangladesh
  case "BT": //Bhutan
  case "KH": //Cambodia
  case "CX": //Christmas Island (Australia)
  case "CC": //Cocos (Keeling) Islands
  case "CK": //Cook Islands (New Zealand)
  case "TP": //East Timor
  case "FJ": //Fiji
  case "PF": //French Polynesia
  case "TF": //French Southern Territories
  case "HM": //Heard and Mcdonald Islands
  case "ID": //Indonesia
  case "KI": //Kiribati
  case "LA": //Laos, People's Democratic Republic
  case "MO": //Macau
  case "MV": //Maldives
  case "MH": //Marshall Islands
  case "FM": //Micronesia
  case "MM": //Myanmar
  case "NR": //Nauru
  case "NP": //Nepal
  case "NU": //Niue
  case "NF": //Norfolk Island
  case "MP": //Northern Mariana Islands
  case "PK": //Pakistan
  case "PW": //Palau
  case "PG": //Papua New Guinea
  case "PH": //Philippines
  case "PN": //Pitcairn
  case "WS": //Samoa
  case "SB": //Solomon Islands
  case "LK": //Sri Lanka
  case "TK": //Tokelau
  case "TO": //Tonga
  case "TV": //Tuvalu
  case "UM": //US Minor Outlying Islands
  case "VU": //Vanuatu
  case "VN": //Vietnam
  case "WF": //Wallis and Futuna Islands
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataAPC;
			 xmsgFormFaxData=xmsgFormFaxDataAPC;
			 xmsgFormMailData=xmsgFormMailDataAPC;
			 Geo="APC";
			 SalutationBlock=SalutationAPC;
			 break;


  case "AL": //Albania
  case "DZ": //Algeria
  case "AD": //Andorra
  case "AO": //Angola
  case "AM": //Armenia
  case "AZ": //Azerbaijan
  case "BH": //Bahrain
  case "BY": //Belarus
  case "BE": //Belgium
		if (country == "BE")
			xmsgOnlineStoreURL=xmsgOnlineStoreURLBE;
  case "BJ": //Benin
  case "BA": //Bosnia and Herzegovina
  case "BW": //Botswana
  case "BV": //Bouvet Island
  case "IO": //British Indian Ocean Territory
  case "BN": //Brunei Darussalam
  case "BG": //Bulgaria
  case "BF": //Burkina Faso
  case "BI": //Burundi
  case "CM": //Cameroon
  case "CV": //Cape Verde
  case "CF": //Central African Republic
  case "TD": //Chad
  case "KM": //Comoros
  case "CG": //Congo
  case "CI": //Cote d'Ivoire
  case "HR": //Croatia (Hrvatska)
  case "CD": //Democratic Republic of the Congo
  case "DJ": //Djibouti
  case "EG": //Egypt
  case "GQ": //Equatorial Guinea
  case "ER": //Eritrea
  case "EE": //Estonia
  case "ET": //Ethiopia
  case "FO": //Faroe Islands
  case "GA": //Gabon
  case "GM": //Gambia
  case "GE": //Georgia
  case "GH": //Ghana
  case "GI": //Gibraltar
  case "GL": //Greenland
  case "GP": //Guadeloupe
  case "GN": //Guinea
  case "GW": //Guinea-Bissau
  case "IS": //Iceland
  case "JO": //Jordan
  case "KZ": //Kazakhstan
  case "KE": //Kenya
  case "KW": //Kuwait
  case "KG": //Kyrgyzstan
  case "LV": //Latvia
  case "LB": //Lebanon
  case "LS": //Lesotho
  case "LR": //Liberia
  case "LI": //Liechtenstein
  case "LT": //Lithuania
  case "LU": //Luxembourg
  case "MK": //Macedonia
  case "MG": //Madagascar
  case "MW": //Malawi
  case "ML": //Mali
  case "MT": //Malta
  case "MR": //Mauritania
  case "MU": //Mauritius
  case "YT": //Mayotte
  case "MD": //Moldova
  case "MC": //Monaco
  case "MN": //Mongolia
  case "MA": //Morocco
  case "MZ": //Mozambique
  case "NA": //Namibia
  case "AN": //Netherlands Antilles
  case "NC": //New Caledonia
  case "NE": //Niger
  case "NG": //Nigeria
  case "OM": //Oman
  case "PS": //Palestinian Territory
  case "QA": //Qatar
  case "RE": //Reunion
  case "RO": //Romania
  case "RW": //Rwanda
  case "SM": //San Marino
  case "ST": //Sao Tome and Principe
  case "SA": //Saudi Arabia
  case "SN": //Senegal
  case "SC": //Seychelles
  case "SL": //Sierra Leone
  case "SK": //Slovak Republic
  case "SI": //Slovenia
  case "SO": //Somalia
  case "SH": //St Helena
  case "SJ": //Svalbard and Jan Mayen Islands
  case "SZ": //Swaziland
  case "SY": //Syria
  case "TJ": //Tajikistan
  case "TZ": //Tanzania, United Republic of
  case "TG": //Togo
  case "TN": //Tunisia
  case "TR": //Turkey
  case "TM": //Turkmenistan
  case "UG": //Uganda
  case "UA": //Ukraine
  case "AE": //United Arab Emirates
  case "UZ": //Uzbekistan
  case "VA": //Vatican City State
  case "EH": //Western Sahara
  case "YE": //Yemen
  case "ZM": //Zambia
  case "ZW": //Zimbabwe
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataEMA;
			 xmsgFormFaxData=xmsgFormFaxDataEMA;
			 xmsgFormMailData=xmsgFormMailDataEMA;
			 Geo="EMA";
			 SalutationBlock=SalutationEMA;
			 break;


  case "AI": //Anguilla
  case "AG": //Antigua and Barbuda
  case "AR": //Argentina
  case "AW": //Aruba
  case "BS": //Bahamas
  case "BB": //Barbados
  case "BZ": //Belize
  case "BM": //Bermuda
  case "BO": //Bolivia
  case "KY": //Cayman Islands
  case "CR": //Costa Rica
  case "DM": //Dominica
  case "DO": //Dominican Republic
  case "EC": //Ecuador
  case "SV": //El Salvador
  case "FK": //Falkland Islands
  case "GF": //French Guiana
  case "GD": //Grenada
  case "GT": //Guatemala
  case "GY": //Guyana
  case "HT": //Haiti
  case "HN": //Honduras
  case "MQ": //Martinique
  case "MS": //Montserrat
  case "NI": //Nicaragua
  case "PA": //Panama
  case "PY": //Paraguay
  case "PE": //Peru
  case "PR": //Puerto Rico
  case "GS": //S. Georgia and S. Sandwich Is.
  case "KN": //Saint Kitts and Nevis
  case "LC": //Saint Lucia
  case "VC": //Saint Vincent Islands
  case "SR": //Suriname
  case "TT": //Trinidad and Tobago
  case "TC": //Turks and Caicos Islands
  case "UY": //Uruguay
  case "VE": //Venezuela
  case "VG": //Virgin Islands (British)
  case "VI": //Virgin Islands (US)
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 xmsgFormEmailData=xmsgFormEmailDataUS;
			 xmsgFormFaxData=xmsgFormFaxDataUS;
			 xmsgFormMailData=xmsgFormMailDataUS;
			 Geo="LAM";
			 SalutationBlock=SalutationUS;
			 break;
  default  : //!!!Unknown codes we make empty and alert
			 InsertStPrRegSelect="";
			 InsertStPrRegText="";
			 Geo="";
			 SalutationBlock="";
			 if (country != "select")
				alert("Erreur: vous n'avez pas entr de code pays connu.");
			 break;
}

}

// Turn off the right click context menu
document.oncontextmenu=fnSuppress;
function fnSuppress() {
    return false;
}

